/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableIntegerInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;

public class NdIntegerInterval
implements NdSingleInterval {
    private final long WjIwOoD;
    private final boolean WjIwOoE;
    private final long WjIwOoF;
    private final boolean WjIwOoG;
    private final boolean WjIwOoH;
    private final boolean WjIwOoI;
    public static final NdIntervalType TYPE = NdIntervalType.INTEGER;
    protected static final boolean OPEN = true;
    protected static final boolean CLOSED = false;
    public static final NdIntegerInterval UNIVERSUM = new NdIntegerInterval(true, Long.MIN_VALUE, Long.MAX_VALUE, true, true, false);
    public static final NdIntegerInterval EMPTY = new NdIntegerInterval(true, 0L, 0L, true, false, true);

    public NdIntegerInterval(char c, long l, long l2, char c2) {
        this(NdIntegerInterval.isOpenChar(c), l, l2, NdIntegerInterval.isOpenChar(c2));
    }

    public NdIntegerInterval(boolean bl, long l, long l2, boolean bl2) {
        this(bl, l, l2, bl2, false, false);
    }

    private NdIntegerInterval(boolean bl, long l, long l2, boolean bl2, boolean bl3, boolean bl4) {
        long l3;
        long l4 = bl ? l + 1L : l;
        long l5 = l3 = bl2 ? l2 - 1L : l2;
        if (!bl4) {
            NdBaseObject.advAssert((l4 <= l3 ? 1 : 0) != 0);
        }
        this.WjIwOoF = l;
        this.WjIwOoG = bl;
        this.WjIwOoD = l2;
        this.WjIwOoE = bl2;
        this.WjIwOoH = bl3;
        this.WjIwOoI = bl4;
    }

    public boolean isEmpty() {
        return this.WjIwOoI;
    }

    public boolean isUniversum() {
        return this.WjIwOoH;
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableIntegerInterval(wjIDdTC, this);
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    private int WjIwOoJ(long l) {
        return (int)(l ^ l >>> 32);
    }

    protected static boolean isOpenChar(char c) {
        return c == '(' || c == ')';
    }

    protected NdIntegerInterval makeInterval(boolean bl, long l, long l2, boolean bl2) {
        return new NdIntegerInterval(bl, l, l2, bl2);
    }

    protected NdIntegerInterval makeInterval(char c, long l, long l2, char c2) {
        return new NdIntegerInterval(c, l, l2, c2);
    }

    protected NdIntegerInterval makeUniversum() {
        return UNIVERSUM;
    }

    public boolean isDegenerate() {
        return false;
    }

    public long getRightBound() {
        return this.WjIwOoD;
    }

    public long getLeftBound() {
        return this.WjIwOoF;
    }

    public boolean isLeftOpen() {
        return this.WjIwOoG;
    }

    public boolean isLeftInfinite() {
        return this.WjIwOoF == Long.MIN_VALUE;
    }

    public boolean isRightOpen() {
        return this.WjIwOoE;
    }

    public boolean isRightInfinite() {
        return this.WjIwOoD == Long.MAX_VALUE;
    }

    public boolean gt(long l) {
        return this.WjIwOoF > l || this.WjIwOoF == l && this.WjIwOoG;
    }

    public boolean lt(long l) {
        return this.WjIwOoD < l || this.WjIwOoD == l && this.WjIwOoE;
    }

    public boolean gtSplit(long l, NdInterval[] ndIntervalArray) {
        boolean bl = this.gt(l);
        if (!bl && (this.WjIwOoD > l + 1L || this.WjIwOoD > l && !this.WjIwOoE)) {
            ndIntervalArray[1] = this.makeInterval(true, l, this.WjIwOoD, this.WjIwOoE);
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, false);
        }
        return bl;
    }

    public boolean ltSplit(long l, NdInterval[] ndIntervalArray) {
        boolean bl = this.lt(l);
        if (!bl && (this.WjIwOoF < l - 1L || this.WjIwOoF < l && !this.WjIwOoG)) {
            ndIntervalArray[1] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, true);
            ndIntervalArray[0] = this.makeInterval(false, l, this.WjIwOoD, this.WjIwOoE);
        }
        return bl;
    }

    public boolean gte(long l) {
        return this.WjIwOoF >= l || this.WjIwOoF == l - 1L && this.WjIwOoG;
    }

    public boolean lte(long l) {
        return this.WjIwOoD <= l || this.WjIwOoD == l + 1L && this.WjIwOoE;
    }

    public boolean gteSplit(long l, NdInterval[] ndIntervalArray) {
        boolean bl = this.gte(l);
        if (!bl && (this.WjIwOoD > l || this.WjIwOoD == l && !this.WjIwOoE)) {
            ndIntervalArray[1] = this.makeInterval(false, l, this.WjIwOoD, this.WjIwOoE);
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, true);
        }
        return bl;
    }

    public boolean lteSplit(long l, NdInterval[] ndIntervalArray) {
        boolean bl = this.lte(l);
        if (!bl && (this.WjIwOoF < l || this.WjIwOoF == l && !this.WjIwOoG)) {
            ndIntervalArray[1] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, false);
            ndIntervalArray[0] = this.makeInterval(true, l, this.WjIwOoD, this.WjIwOoE);
        }
        return bl;
    }

    private boolean WjIwOoK(long l) {
        return l == this.WjIwOoF && !this.WjIwOoG || l == this.WjIwOoF + 1L && this.WjIwOoG;
    }

    private boolean WjIwOoL(long l) {
        return l == this.WjIwOoD && !this.WjIwOoE || l == this.WjIwOoD - 1L && this.WjIwOoE;
    }

    private boolean WjIwOoM(long l) {
        return this.WjIwOoF < l - 1L || this.WjIwOoF < l && !this.WjIwOoG;
    }

    private boolean WjIwOoN(long l) {
        return this.WjIwOoD > l + 1L || this.WjIwOoD > l && !this.WjIwOoE;
    }

    public boolean eq(long l) {
        return this.WjIwOoK(l) && this.WjIwOoL(l);
    }

    public boolean eqSplit(long l, NdInterval[] ndIntervalArray) {
        boolean bl = false;
        if (this.eq(l)) {
            bl = true;
        } else if (this.WjIwOoL(l)) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, true);
            ndIntervalArray[1] = this.makeInterval(false, l, this.WjIwOoD, this.WjIwOoE);
        } else if (this.WjIwOoK(l)) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, false);
            ndIntervalArray[1] = this.makeInterval(true, l, this.WjIwOoD, this.WjIwOoE);
        } else if (this.WjIwOoM(l) && this.WjIwOoN(l)) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, l, true);
            ndIntervalArray[1] = this.makeInterval(false, l, l, false);
            ndIntervalArray[2] = this.makeInterval(true, l, this.WjIwOoD, this.WjIwOoE);
        }
        return bl;
    }

    void WjIwOoO(NdIntegerInterval ndIntegerInterval, NdInterval[] ndIntervalArray) {
        long l;
        long l2 = this.WjIwOoG ? this.WjIwOoF + 1L : this.WjIwOoF;
        long l3 = this.WjIwOoE ? this.WjIwOoD - 1L : this.WjIwOoD;
        NdIntegerInterval ndIntegerInterval2 = (NdIntegerInterval)this.intersect(ndIntegerInterval);
        long l4 = ndIntegerInterval2.WjIwOoG ? ndIntegerInterval2.WjIwOoF + 1L : ndIntegerInterval2.WjIwOoF;
        long l5 = l = ndIntegerInterval2.WjIwOoE ? ndIntegerInterval2.WjIwOoD - 1L : ndIntegerInterval2.WjIwOoD;
        if (l4 == l2) {
            ndIntervalArray[0] = ndIntegerInterval2;
            ndIntervalArray[1] = this.makeInterval(!ndIntegerInterval2.WjIwOoE, ndIntegerInterval2.WjIwOoD, this.WjIwOoD, this.WjIwOoE);
            ndIntervalArray[2] = null;
        } else if (l == l3) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, ndIntegerInterval2.WjIwOoF, !ndIntegerInterval2.WjIwOoG);
            ndIntervalArray[1] = ndIntegerInterval2;
            ndIntervalArray[2] = null;
        } else {
            ndIntervalArray[0] = this.makeInterval(this.WjIwOoG, this.WjIwOoF, ndIntegerInterval2.WjIwOoF, !ndIntegerInterval2.WjIwOoG);
            ndIntervalArray[1] = ndIntegerInterval2;
            ndIntervalArray[2] = this.makeInterval(!ndIntegerInterval2.WjIwOoE, ndIntegerInterval2.WjIwOoD, this.WjIwOoD, this.WjIwOoE);
        }
    }

    public boolean intersects(NdIntegerInterval ndIntegerInterval) {
        long l = ndIntegerInterval.WjIwOoG ? ndIntegerInterval.WjIwOoF + 1L : ndIntegerInterval.WjIwOoF;
        long l2 = ndIntegerInterval.WjIwOoE ? ndIntegerInterval.WjIwOoD - 1L : ndIntegerInterval.WjIwOoD;
        long l3 = this.WjIwOoG ? this.WjIwOoF + 1L : this.WjIwOoF;
        long l4 = this.WjIwOoE ? this.WjIwOoD - 1L : this.WjIwOoD;
        return l4 >= l && l3 <= l2;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdIntegerInterval ndIntegerInterval;
        NdIntegerInterval ndIntegerInterval2 = (NdIntegerInterval)ndSingleInterval;
        if (this.intersects(ndIntegerInterval2)) {
            long l;
            long l2 = this.WjIwOoG ? this.WjIwOoF + 1L : this.WjIwOoF;
            long l3 = this.WjIwOoE ? this.WjIwOoD - 1L : this.WjIwOoD;
            long l4 = ndIntegerInterval2.WjIwOoG ? ndIntegerInterval2.WjIwOoF + 1L : ndIntegerInterval2.WjIwOoF;
            long l5 = l = ndIntegerInterval2.WjIwOoE ? ndIntegerInterval2.WjIwOoD - 1L : ndIntegerInterval2.WjIwOoD;
            ndIntegerInterval = l4 > l2 ? (l < l3 ? this.makeInterval(ndIntegerInterval2.WjIwOoG, ndIntegerInterval2.WjIwOoF, ndIntegerInterval2.WjIwOoD, ndIntegerInterval2.WjIwOoE) : this.makeInterval(ndIntegerInterval2.WjIwOoG, ndIntegerInterval2.WjIwOoF, this.WjIwOoD, this.WjIwOoE)) : (l < l3 ? this.makeInterval(this.WjIwOoG, this.WjIwOoF, ndIntegerInterval2.WjIwOoD, ndIntegerInterval2.WjIwOoE) : this.makeInterval(this.WjIwOoG, this.WjIwOoF, this.WjIwOoD, this.WjIwOoE));
        } else {
            ndIntegerInterval = EMPTY;
        }
        return ndIntegerInterval;
    }

    public boolean contains(NdIntegerInterval ndIntegerInterval) {
        long l = ndIntegerInterval.WjIwOoG ? ndIntegerInterval.WjIwOoF + 1L : ndIntegerInterval.WjIwOoF;
        long l2 = ndIntegerInterval.WjIwOoE ? ndIntegerInterval.WjIwOoD - 1L : ndIntegerInterval.WjIwOoD;
        long l3 = this.WjIwOoG ? this.WjIwOoF + 1L : this.WjIwOoF;
        long l4 = this.WjIwOoE ? this.WjIwOoD - 1L : this.WjIwOoD;
        return l3 <= l && l4 >= l2;
    }

    public boolean equivalent(NdIntegerInterval ndIntegerInterval) {
        long l = ndIntegerInterval.WjIwOoG ? ndIntegerInterval.WjIwOoF + 1L : ndIntegerInterval.WjIwOoF;
        long l2 = ndIntegerInterval.WjIwOoE ? ndIntegerInterval.WjIwOoD - 1L : ndIntegerInterval.WjIwOoD;
        long l3 = this.WjIwOoG ? this.WjIwOoF + 1L : this.WjIwOoF;
        long l4 = this.WjIwOoE ? this.WjIwOoD - 1L : this.WjIwOoD;
        return l4 == l2 && l3 == l;
    }

    public boolean isEquality() {
        return this.WjIwOoF == this.WjIwOoD && !this.WjIwOoG && !this.WjIwOoE;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdIntegerInterval) {
            NdIntegerInterval ndIntegerInterval = (NdIntegerInterval)object;
            bl = this.WjIwOoF == ndIntegerInterval.WjIwOoF && this.WjIwOoD == ndIntegerInterval.WjIwOoD && this.WjIwOoG == ndIntegerInterval.WjIwOoG && this.WjIwOoE == ndIntegerInterval.WjIwOoE;
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIwOoJ(this.WjIwOoF) | this.WjIwOoJ(this.WjIwOoD) | (this.WjIwOoG ? 0 : 0x10000000) | (this.WjIwOoE ? 0 : 0x1000000);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Integer: ");
        stringBuffer.append(this.WjIwOoG ? (char)'(' : '[');
        stringBuffer.append(this.WjIwOoF).append(", ").append(this.WjIwOoD);
        stringBuffer.append(this.WjIwOoE ? (char)')' : ']');
        return stringBuffer.toString();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this.WjIwOoF == Long.MIN_VALUE && this.WjIwOoD == Long.MAX_VALUE) {
            stringBuffer.append("-inf < x and x < +inf");
        } else {
            stringBuffer.append(string);
            if (this.WjIwOoF == Long.MIN_VALUE) {
                stringBuffer.append(this.WjIwOoE ? " < " : " <= ");
                stringBuffer.append(this.WjIwOoD);
            } else if (this.WjIwOoD == Long.MAX_VALUE) {
                stringBuffer.append(this.WjIwOoG ? " > " : " >= ");
                stringBuffer.append(this.WjIwOoF);
            } else if (this.isEquality()) {
                stringBuffer.append(" = ");
                stringBuffer.append(this.WjIwOoF);
            } else {
                stringBuffer.append(this.WjIwOoG ? " > " : " >= ");
                stringBuffer.append(this.WjIwOoF);
                stringBuffer.append(") and (");
                stringBuffer.append(string);
                stringBuffer.append(this.WjIwOoE ? " < " : " <= ");
                stringBuffer.append(this.WjIwOoD);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

