/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationStatusMessage;
import com.blazesoft.verifier.NdVerifierCallback;
import com.blazesoft.verifier.cfa.consistency.NdSplitCoverageVerifier;
import com.blazesoft.verifier.cfa.spatial.NdBasis;
import com.blazesoft.verifier.cfa.spatial.NdBasisImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdDiscreetConvex;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.intervals.NdBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdBooleanMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdEnumeratedTypeMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalHelper;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdMoneyMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdReferenceTypeMultiInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringMultiInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdImplicitDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraDomain;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedraFactory;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.type.NdModelEnumeratedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NdIntervalGrid
implements NdShape {
    public static final int BOUND_EXCLUDE = 0;
    public static final int BOUND_INCLUDE = 1;
    public static final int BOUND_ONLY = 2;
    private final NdBasisImpl WjIwLqR;
    private final Map WjIwLqS;
    private final NdPolyhedraDomain WjIwLqT;
    private static final NdPolyhedraFactory WjIwLqU = NdPolyhedraFactory.getInstance();

    public NdIntervalGrid(NdBasisImpl ndBasisImpl) {
        this.WjIwLqR = ndBasisImpl;
        this.WjIwLqS = new HashMap();
        this.WjIwLqT = new NdPolyhedraDomain(this.WjIwLqR.getLinearView());
        this.WjIwLqT.addUniversum();
    }

    private final boolean WjIwLqV(NdVerifierCallback ndVerifierCallback) {
        boolean bl = false;
        if (ndVerifierCallback != null) {
            bl = !ndVerifierCallback.fireStatusUpdate(NdVerificationStatusMessage.makeInProgress(NdSplitCoverageVerifier.NAME, 0.0));
        }
        Thread.yield();
        return bl;
    }

    public Object accept(NdShapeVisitor ndShapeVisitor, Object object) throws NdShapeException {
        throw NdBaseObject.apiError((String)"Visitor is not supported");
    }

    public NdMultiInterval getVector(String string) {
        return (NdMultiInterval)this.WjIwLqS.get(string);
    }

    public NdBasis getBasis() {
        return this.WjIwLqR;
    }

    public NdShape[] getElements() {
        throw NdBaseObject.apiError((String)"Visitor is not supported");
    }

    public void addLinearCombination(List list, int n) throws NdPolyhedraException {
        long[] lArray = NdImplicitDef.prepareCoefficients(this.WjIwLqT.getBasis(), list);
        NdImplicitDef ndImplicitDef = WjIwLqU.getImplicitDef(1, this.WjIwLqT.getBasis().getDimension() + 1);
        switch (n) {
            case 0: {
                ndImplicitDef.addConstraint(lArray, 0, lArray.length, 2);
                break;
            }
            case 1: {
                ndImplicitDef.addConstraint(lArray, 0, lArray.length, 1);
                break;
            }
            case 2: {
                ndImplicitDef.addConstraint(lArray, 0, lArray.length, 0);
            }
        }
        this.WjIwLqT.split(ndImplicitDef);
    }

    public void splitLinearDomain(NdImplicitDef ndImplicitDef) throws NdPolyhedraException {
        this.WjIwLqT.split(ndImplicitDef);
    }

    private NdMultiInterval WjIwLqW(WjIDdTC wjIDdTC, NdIntervalType ndIntervalType) {
        NdMultiInterval ndMultiInterval;
        switch (ndIntervalType.getType()) {
            case 3: {
                ndMultiInterval = new NdBooleanMultiInterval(wjIDdTC);
                break;
            }
            case 1: {
                ndMultiInterval = new NdIntegerMultiInterval(wjIDdTC);
                break;
            }
            case 2: {
                ndMultiInterval = new NdRealMultiInterval(wjIDdTC);
                break;
            }
            case 5: {
                ndMultiInterval = new NdReferenceTypeMultiInterval(wjIDdTC);
                break;
            }
            case 4: {
                ndMultiInterval = new NdStringMultiInterval(wjIDdTC);
                break;
            }
            case 6: {
                ndMultiInterval = new NdEnumeratedTypeMultiInterval(wjIDdTC);
                break;
            }
            case 10: {
                ndMultiInterval = new NdMoneyMultiInterval(wjIDdTC);
                break;
            }
            default: {
                throw NdBaseObject.apiError((String)("No intervals defined for variable " + wjIDdTC));
            }
        }
        return ndMultiInterval;
    }

    private NdMultiInterval WjIwLqX(WjIDdTC wjIDdTC, NdIntervalType ndIntervalType) {
        NdMultiInterval ndMultiInterval;
        switch (ndIntervalType.getType()) {
            case 3: {
                ndMultiInterval = new NdBooleanMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(NdBooleanInterval.FALSE);
                break;
            }
            case 1: {
                ndMultiInterval = new NdIntegerMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(NdIntegerInterval.UNIVERSUM);
                break;
            }
            case 2: {
                ndMultiInterval = new NdRealMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(NdRealInterval.UNIVERSUM);
                break;
            }
            case 5: {
                ndMultiInterval = new NdReferenceTypeMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(NdReferenceTypeInterval.NULL);
                break;
            }
            case 4: {
                ndMultiInterval = new NdStringMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(this.WjIwLqR.getStringDomain(wjIDdTC).getInterval());
                break;
            }
            case 6: {
                ndMultiInterval = new NdEnumeratedTypeMultiInterval(wjIDdTC);
                ndMultiInterval.insertInterval(new NdEnumeratedTypeInterval((NdModelEnumeratedType)wjIDdTC.WjICXCU()));
                break;
            }
            case 10: {
                ndMultiInterval = new NdMoneyMultiInterval(wjIDdTC);
                break;
            }
            default: {
                throw NdBaseObject.apiError((String)("No intervals defined for variable " + wjIDdTC));
            }
        }
        return ndMultiInterval;
    }

    public void insertInterval(WjIDdTC wjIDdTC, NdSingleInterval ndSingleInterval) {
        NdMultiInterval ndMultiInterval = (NdMultiInterval)this.WjIwLqS.get(wjIDdTC.WjIDbnY());
        if (ndMultiInterval == null) {
            ndMultiInterval = this.WjIwLqW(wjIDdTC, ndSingleInterval.getIntervalType());
            this.WjIwLqS.put(wjIDdTC.WjIDbnY(), ndMultiInterval);
        }
        ndMultiInterval.insertInterval(ndSingleInterval);
    }

    public void insertUniverseInterval(WjIDdTC wjIDdTC) {
        NdMultiInterval ndMultiInterval = (NdMultiInterval)this.WjIwLqS.get(wjIDdTC.WjIDbnY());
        if (ndMultiInterval == null) {
            ndMultiInterval = this.WjIwLqX(wjIDdTC, NdIntervalHelper.modelTypeToIntervalType(wjIDdTC.WjICXCU()));
            this.WjIwLqS.put(wjIDdTC.WjIDbnY(), ndMultiInterval);
        }
    }

    public List prepareCoverages(NdVerifierCallback ndVerifierCallback) {
        Object object;
        block13: {
            Object object2;
            Object object3;
            Set set = this.WjIwLqS.keySet();
            ArrayList<NdDiscreetConvex> arrayList = new ArrayList<NdDiscreetConvex>();
            Iterator iterator = set.iterator();
            long l = 0L;
            if (iterator.hasNext()) {
                NdHyperCube ndHyperCube;
                int n;
                object = (String)iterator.next();
                object3 = (NdMultiInterval)this.WjIwLqS.get(object);
                object2 = ((NdMultiInterval)object3).getIntervals();
                for (n = 0; n < object2.size(); ++n) {
                    ndHyperCube = new NdHyperCube(this.WjIwLqR);
                    ndHyperCube.putInterval((String)object, (NdSingleInterval)object2.get(n));
                    arrayList.add(ndHyperCube);
                }
                block1: while (iterator.hasNext()) {
                    object = (String)iterator.next();
                    object3 = (NdMultiInterval)this.WjIwLqS.get(object);
                    object2 = ((NdMultiInterval)object3).getIntervals();
                    for (n = arrayList.size(); n > 0; --n) {
                        ndHyperCube = (NdHyperCube)arrayList.remove(0);
                        int n2 = 0;
                        while (n2 < object2.size()) {
                            if (l % 10000L == 0L && this.WjIwLqV(ndVerifierCallback)) break block1;
                            NdDiscreetConvex ndDiscreetConvex = (NdDiscreetConvex)ndHyperCube.cloneMe();
                            ndDiscreetConvex.putInterval((String)object, (NdSingleInterval)object2.get(n2));
                            arrayList.add(ndDiscreetConvex);
                            ++n2;
                            ++l;
                        }
                    }
                }
            }
            object = new ArrayList();
            if (this.WjIwLqV(ndVerifierCallback)) break block13;
            if (arrayList.size() > 0) {
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object2 = (NdHyperCube)object3.next();
                    if (this.WjIwLqT.getSize() > 0) {
                        Iterator iterator2 = this.WjIwLqT.getPolyhedrons().iterator();
                        while (iterator2.hasNext()) {
                            if (l % 10000L != 0L || !this.WjIwLqV(ndVerifierCallback)) {
                                object.add(new NdComboShape((NdHyperCube)object2, (NdPolyhedron)iterator2.next()));
                                ++l;
                                continue;
                            }
                            break block13;
                        }
                        continue;
                    }
                    object.add(new NdComboShape((NdHyperCube)object2));
                }
            } else {
                object3 = this.WjIwLqT.getPolyhedrons().iterator();
                while (object3.hasNext() && (l % 100L != 0L || !this.WjIwLqV(ndVerifierCallback))) {
                    object2 = (NdPolyhedron)object3.next();
                    if (!((NdPolyhedron)object2).isUniversum()) {
                        object.add(new NdComboShape((NdPolyhedron)object2));
                    }
                    ++l;
                }
            }
        }
        return object;
    }
}

