/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableRealInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;

public class NdRealInterval
implements NdSingleInterval {
    private final double WjIwNiC;
    private final double WjIwNiD;
    private final boolean WjIwNiE;
    private final boolean WjIwNiF;
    private final boolean WjIwNiG;
    private final boolean WjIwNiH;
    public static final NdIntervalType TYPE = NdIntervalType.REAL;
    protected static final boolean OPEN = true;
    protected static final boolean CLOSED = false;
    public static final NdRealInterval UNIVERSUM = new NdRealInterval(true, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true, true, false);
    public static final NdRealInterval EMPTY = new NdRealInterval(true, 0.0, 0.0, true, false, true);

    public NdRealInterval(char c, double d, double d2, char c2) {
        this(NdRealInterval.isOpenChar(c), d, d2, NdRealInterval.isOpenChar(c2));
    }

    public NdRealInterval(boolean bl, double d, double d2, boolean bl2) {
        this(bl, d, d2, bl2, false, false);
    }

    private NdRealInterval(boolean bl, double d, double d2, boolean bl2, boolean bl3, boolean bl4) {
        if (!bl4) {
            NdBaseObject.advAssert((d < d2 || d == d2 && !bl && !bl2 ? 1 : 0) != 0);
        }
        this.WjIwNiD = d;
        this.WjIwNiF = bl;
        this.WjIwNiC = d2;
        this.WjIwNiE = bl2;
        this.WjIwNiG = bl3;
        this.WjIwNiH = bl4;
    }

    public boolean isEmpty() {
        return this.WjIwNiH;
    }

    public boolean isUniversum() {
        return this.WjIwNiG;
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableRealInterval(wjIDdTC, this);
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    protected static boolean isOpenChar(char c) {
        return c == '(' || c == ')';
    }

    protected NdSingleInterval makeInterval(boolean bl, double d, double d2, boolean bl2) {
        return new NdRealInterval(bl, d, d2, bl2);
    }

    protected NdSingleInterval makeInterval(char c, double d, double d2, char c2) {
        return new NdRealInterval(c, d, d2, c2);
    }

    protected NdRealInterval makeUniversum() {
        return UNIVERSUM;
    }

    public boolean isDegenerate() {
        return false;
    }

    public double getRightBound() {
        return this.WjIwNiC;
    }

    public double getLeftBound() {
        return this.WjIwNiD;
    }

    public boolean isLeftOpen() {
        return this.WjIwNiF;
    }

    public boolean isLeftInfinite() {
        return this.WjIwNiD == Double.NEGATIVE_INFINITY;
    }

    public boolean isRightOpen() {
        return this.WjIwNiE;
    }

    public boolean isRightInfinite() {
        return this.WjIwNiC == Double.POSITIVE_INFINITY;
    }

    public boolean gt(double d) {
        return this.WjIwNiD > d || this.WjIwNiD == d && this.WjIwNiF;
    }

    public boolean lt(double d) {
        return this.WjIwNiC < d || this.WjIwNiC == d && this.WjIwNiE;
    }

    public boolean gtSplit(double d, NdInterval[] ndIntervalArray) {
        boolean bl = this.gt(d);
        if (!bl && this.WjIwNiC > d) {
            ndIntervalArray[1] = this.makeInterval(true, d, this.WjIwNiC, this.WjIwNiE);
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, false);
        }
        return bl;
    }

    public boolean ltSplit(double d, NdInterval[] ndIntervalArray) {
        boolean bl = this.lt(d);
        if (!bl && this.WjIwNiD < d) {
            ndIntervalArray[1] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, true);
            ndIntervalArray[0] = this.makeInterval(false, d, this.WjIwNiC, this.WjIwNiE);
        }
        return bl;
    }

    public boolean gte(double d) {
        return this.WjIwNiD >= d;
    }

    public boolean lte(double d) {
        return this.WjIwNiC <= d;
    }

    public boolean gteSplit(double d, NdInterval[] ndIntervalArray) {
        boolean bl = this.gte(d);
        if (!bl && (this.WjIwNiC > d || this.WjIwNiC == d && !this.WjIwNiE)) {
            ndIntervalArray[1] = this.makeInterval(false, d, this.WjIwNiC, this.WjIwNiE);
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, true);
        }
        return bl;
    }

    public boolean lteSplit(double d, NdInterval[] ndIntervalArray) {
        boolean bl = this.lte(d);
        if (!bl && (this.WjIwNiD < d || this.WjIwNiD == d && !this.WjIwNiF)) {
            ndIntervalArray[1] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, false);
            ndIntervalArray[0] = this.makeInterval(true, d, this.WjIwNiC, this.WjIwNiE);
        }
        return bl;
    }

    public boolean eq(double d) {
        return this.WjIwNiD == d && this.WjIwNiC == d;
    }

    public boolean eqSplit(double d, NdInterval[] ndIntervalArray) {
        boolean bl = false;
        if (this.eq(d)) {
            bl = true;
        } else if (d == this.WjIwNiC) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, true);
            ndIntervalArray[1] = this.makeInterval(false, d, this.WjIwNiC, this.WjIwNiE);
        } else if (this.WjIwNiD == d) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, false);
            ndIntervalArray[1] = this.makeInterval(true, d, this.WjIwNiC, this.WjIwNiE);
        } else if (this.WjIwNiD < d && this.WjIwNiC > d) {
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, d, true);
            ndIntervalArray[1] = this.makeInterval(false, d, d, false);
            ndIntervalArray[2] = this.makeInterval(true, d, this.WjIwNiC, this.WjIwNiE);
        }
        return bl;
    }

    void WjIwNiI(NdSingleInterval ndSingleInterval, NdInterval[] ndIntervalArray) {
        NdRealInterval ndRealInterval = (NdRealInterval)this.intersect(ndSingleInterval);
        if (ndRealInterval.WjIwNiD == this.WjIwNiD) {
            if (ndRealInterval.WjIwNiF != this.WjIwNiF) {
                ndIntervalArray[0] = this.makeInterval(false, this.WjIwNiD, this.WjIwNiD, false);
                NdBaseObject.advAssert((boolean)ndRealInterval.WjIwNiF);
                ndIntervalArray[1] = ndRealInterval;
                ndIntervalArray[2] = this.makeInterval(!ndRealInterval.WjIwNiE, ndRealInterval.WjIwNiC, this.WjIwNiC, this.WjIwNiE);
            } else {
                ndIntervalArray[0] = ndRealInterval;
                ndIntervalArray[1] = this.makeInterval(!ndRealInterval.WjIwNiE, ndRealInterval.WjIwNiC, this.WjIwNiC, this.WjIwNiE);
                ndIntervalArray[2] = null;
            }
        } else if (ndRealInterval.WjIwNiC == this.WjIwNiC) {
            if (ndRealInterval.WjIwNiE != this.WjIwNiE) {
                ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, ndRealInterval.WjIwNiD, !ndRealInterval.WjIwNiF);
                ndIntervalArray[1] = ndRealInterval;
                NdBaseObject.advAssert((boolean)ndRealInterval.WjIwNiE);
                ndIntervalArray[2] = this.makeInterval(false, this.WjIwNiD, this.WjIwNiD, false);
            } else {
                ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, ndRealInterval.WjIwNiD, !ndRealInterval.WjIwNiF);
                ndIntervalArray[1] = ndRealInterval;
                ndIntervalArray[2] = null;
            }
        } else {
            ndIntervalArray[0] = this.makeInterval(this.WjIwNiF, this.WjIwNiD, ndRealInterval.WjIwNiD, !ndRealInterval.WjIwNiF);
            ndIntervalArray[1] = ndRealInterval;
            ndIntervalArray[2] = this.makeInterval(!ndRealInterval.WjIwNiE, ndRealInterval.WjIwNiC, this.WjIwNiC, this.WjIwNiE);
        }
    }

    public boolean intersects(NdRealInterval ndRealInterval) {
        double d = ndRealInterval.WjIwNiD;
        double d2 = ndRealInterval.WjIwNiC;
        boolean bl = !ndRealInterval.WjIwNiF;
        boolean bl2 = !ndRealInterval.WjIwNiE;
        double d3 = this.WjIwNiD;
        double d4 = this.WjIwNiC;
        boolean bl3 = !this.WjIwNiF;
        boolean bl4 = !this.WjIwNiE;
        return (d4 > d || d4 == d && bl4 && bl) && (d3 < d2 || d3 == d2 && bl3 && bl2);
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdSingleInterval ndSingleInterval2;
        NdRealInterval ndRealInterval = (NdRealInterval)ndSingleInterval;
        if (this.intersects(ndRealInterval)) {
            if (ndRealInterval.WjIwNiD > this.WjIwNiD) {
                ndSingleInterval2 = ndRealInterval.WjIwNiC < this.WjIwNiC ? this.makeInterval(ndRealInterval.WjIwNiF, ndRealInterval.WjIwNiD, ndRealInterval.WjIwNiC, ndRealInterval.WjIwNiE) : (ndRealInterval.WjIwNiC == this.WjIwNiC ? this.makeInterval(ndRealInterval.WjIwNiF, ndRealInterval.WjIwNiD, ndRealInterval.WjIwNiC, ndRealInterval.WjIwNiE | this.WjIwNiE) : this.makeInterval(ndRealInterval.WjIwNiF, ndRealInterval.WjIwNiD, this.WjIwNiC, this.WjIwNiE));
            } else {
                boolean bl = ndRealInterval.WjIwNiD == this.WjIwNiD ? ndRealInterval.WjIwNiF | this.WjIwNiF : this.WjIwNiF;
                ndSingleInterval2 = ndRealInterval.WjIwNiC < this.WjIwNiC ? this.makeInterval(bl, this.WjIwNiD, ndRealInterval.WjIwNiC, ndRealInterval.WjIwNiE) : (ndRealInterval.WjIwNiC == this.WjIwNiC ? this.makeInterval(bl, this.WjIwNiD, ndRealInterval.WjIwNiC, ndRealInterval.WjIwNiE | this.WjIwNiE) : this.makeInterval(bl, this.WjIwNiD, this.WjIwNiC, this.WjIwNiE));
            }
        } else {
            ndSingleInterval2 = EMPTY;
        }
        return ndSingleInterval2;
    }

    public boolean contains(NdRealInterval ndRealInterval) {
        double d = ndRealInterval.WjIwNiD;
        double d2 = ndRealInterval.WjIwNiC;
        boolean bl = !ndRealInterval.WjIwNiF;
        boolean bl2 = !ndRealInterval.WjIwNiE;
        double d3 = this.WjIwNiD;
        double d4 = this.WjIwNiC;
        boolean bl3 = !this.WjIwNiF;
        boolean bl4 = !this.WjIwNiE;
        return (d3 < d || d3 == d && (bl3 == bl || !bl)) && (d4 > d2 || d4 == d2 && (bl4 == bl2 || !bl2));
    }

    public boolean equivalent(NdRealInterval ndRealInterval) {
        return this.WjIwNiD == ndRealInterval.WjIwNiD && this.WjIwNiF == ndRealInterval.WjIwNiF && this.WjIwNiC == ndRealInterval.WjIwNiC && this.WjIwNiE == ndRealInterval.WjIwNiE;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdRealInterval) {
            bl = this.equivalent((NdRealInterval)object);
        }
        return bl;
    }

    private int WjIwNiJ(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public int hashCode() {
        return this.WjIwNiJ(this.WjIwNiD) | this.WjIwNiJ(this.WjIwNiC) | (this.WjIwNiF ? 0 : 0x10000000) | (this.WjIwNiE ? 0 : 0x1000000);
    }

    public boolean isEquality() {
        return this.WjIwNiD == this.WjIwNiC && !this.WjIwNiF && !this.WjIwNiE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Real: ");
        stringBuffer.append(this.WjIwNiF ? (char)'(' : '[');
        stringBuffer.append(this.WjIwNiD).append(", ").append(this.WjIwNiC);
        stringBuffer.append(this.WjIwNiE ? (char)')' : ']');
        return stringBuffer.toString();
    }

    private String WjIwNiK(double d) {
        return d == 0.0 ? "0" : Double.toString(d);
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(string);
        if (this.WjIwNiD == Double.NEGATIVE_INFINITY) {
            stringBuffer.append(this.WjIwNiE ? " < " : " <= ");
            stringBuffer.append(this.WjIwNiK(this.WjIwNiC));
        } else if (this.WjIwNiC == Double.POSITIVE_INFINITY) {
            stringBuffer.append(this.WjIwNiF ? " > " : " >= ");
            stringBuffer.append(this.WjIwNiK(this.WjIwNiD));
        } else if (this.isEquality()) {
            stringBuffer.append(" = ");
            stringBuffer.append(this.WjIwNiK(this.WjIwNiD));
        } else {
            stringBuffer.append(this.WjIwNiF ? " > " : " >= ");
            stringBuffer.append(this.WjIwNiK(this.WjIwNiD));
            stringBuffer.append(") and (");
            stringBuffer.append(string);
            stringBuffer.append(this.WjIwNiE ? " < " : " <= ");
            stringBuffer.append(this.WjIwNiK(this.WjIwNiC));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

