/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.intervals;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.intervals.NdInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntervalType;
import com.blazesoft.verifier.cfa.spatial.intervals.NdSingleInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalDomain;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringIntervalFactory;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.predicate.WjIDdTC;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class NdStringInterval
implements NdSingleInterval {
    private static final NdStringIntervalFactory WjIwWJS = NdStringIntervalFactory.getInstance();
    public static final NdIntervalType TYPE = NdIntervalType.STRING;
    private final SortedSet WjIRaiP;
    private int WjIwWLU;
    private final NdStringIntervalDomain WjIwWMV;

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain, SortedSet sortedSet) {
        NdBaseObject.advAssertNonNull((Object)sortedSet);
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIRaiP = sortedSet;
        this.WjIwWNW();
    }

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain, String string) {
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIRaiP = new TreeSet();
        this.WjIRaiP.add(WjIwWJS.getValue(ndStringIntervalDomain, string));
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIwWNW();
    }

    NdStringInterval(NdStringIntervalDomain ndStringIntervalDomain) {
        NdBaseObject.advAssertNonNull((Object)ndStringIntervalDomain);
        this.WjIRaiP = new TreeSet();
        this.WjIwWMV = ndStringIntervalDomain;
        this.WjIwWNW();
    }

    private void WjIwWNW() {
        this.WjIwWLU = 0;
    }

    public NdSingleInterval intersect(NdSingleInterval ndSingleInterval) {
        NdStringInterval ndStringInterval = (NdStringInterval)ndSingleInterval;
        TreeSet treeSet = new TreeSet(this.WjIRaiP);
        treeSet.retainAll(ndStringInterval.WjIRaiP);
        return new NdStringInterval(this.WjIwWMV, treeSet);
    }

    public NdSingleInterval union(NdSingleInterval ndSingleInterval) {
        NdBaseObject.advAssertNonNull((Object)ndSingleInterval);
        NdStringInterval ndStringInterval = (NdStringInterval)ndSingleInterval;
        TreeSet treeSet = new TreeSet(this.WjIRaiP);
        treeSet.addAll(ndStringInterval.WjIRaiP);
        NdStringInterval ndStringInterval2 = new NdStringInterval(this.WjIwWMV, treeSet);
        return ndStringInterval2;
    }

    public NdStringInterval cloneMe() {
        TreeSet treeSet = new TreeSet(this.WjIRaiP);
        return new NdStringInterval(this.WjIwWMV, treeSet);
    }

    public NdStringInterval subtract(String string) {
        TreeSet treeSet = new TreeSet(this.WjIRaiP);
        treeSet.remove(WjIwWJS.getValue(this.WjIwWMV, string));
        return new NdStringInterval(this.WjIwWMV, treeSet);
    }

    public NdStringInterval subtract(NdStringInterval ndStringInterval) {
        TreeSet treeSet = new TreeSet(this.WjIRaiP);
        treeSet.removeAll(ndStringInterval.WjIRaiP);
        return new NdStringInterval(this.WjIwWMV, treeSet);
    }

    public boolean isEmpty() {
        return this.WjIRaiP.size() == 0;
    }

    public boolean isUniversum() {
        NdBaseObject.advAssert((boolean)false);
        return false;
    }

    public NdShape makeShape(WjIDdTC wjIDdTC) {
        return new NdVariableStringInterval(wjIDdTC, this);
    }

    public NdIntervalType getIntervalType() {
        return TYPE;
    }

    public StringValue[] getElements() {
        StringValue[] stringValueArray = new StringValue[this.WjIRaiP.size()];
        int n = 0;
        Iterator iterator = this.WjIRaiP.iterator();
        while (iterator.hasNext()) {
            StringValue stringValue = (StringValue)iterator.next();
            stringValueArray[n++] = stringValue;
        }
        return stringValueArray;
    }

    public boolean isDegenerate() {
        return false;
    }

    public boolean eq(NdInterval ndInterval) {
        NdStringInterval ndStringInterval = (NdStringInterval)ndInterval;
        return this.WjIwWLU == ndStringInterval.WjIwWLU && this.WjIRaiP.equals(ndStringInterval.WjIRaiP);
    }

    public boolean eq(String string) {
        return this.WjIRaiP.contains(WjIwWJS.getValue(this.WjIwWMV, string));
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && object instanceof NdStringInterval) {
            NdStringInterval ndStringInterval = (NdStringInterval)object;
            bl = this.eq(ndStringInterval);
        }
        return bl;
    }

    public int hashCode() {
        return this.WjIwWLU;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        Iterator iterator = this.WjIRaiP.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toAnalyticalString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(').append(string).append(" in {");
        Iterator iterator = this.WjIRaiP.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("})");
        return stringBuffer.toString();
    }

    public static class StringValue
    implements Comparable {
        public final String value;
        public final boolean isComplement;
        private NdStringIntervalDomain WjIwTjS;

        StringValue(NdStringIntervalDomain ndStringIntervalDomain, String string) {
            this.value = string;
            this.isComplement = false;
            this.WjIwTjS = ndStringIntervalDomain;
        }

        StringValue(NdStringIntervalDomain ndStringIntervalDomain) {
            this.value = null;
            this.isComplement = true;
            this.WjIwTjS = ndStringIntervalDomain;
        }

        public StringValue[] getComplementValues() {
            NdBaseObject.advAssertNonNull((Object)this.WjIwTjS);
            NdStringInterval ndStringInterval = this.WjIwTjS.getInterval();
            return ndStringInterval.getElements();
        }

        public int hashCode() {
            int n = this.isComplement ? 1 : (this.value == null ? 0 : this.value.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            StringValue stringValue = (StringValue)object;
            boolean bl = this == stringValue ? true : (this.isComplement ? stringValue.isComplement : (this.value == null ? stringValue.value == null : this.value.equals(stringValue.value)));
            return bl;
        }

        public int compareTo(Object object) {
            StringValue stringValue = (StringValue)object;
            int n = 1;
            if (this == stringValue) {
                n = 0;
            } else if (this.isComplement) {
                n = stringValue.isComplement ? 0 : 1;
            } else if (this.value == null) {
                n = stringValue.value == null ? 0 : 1;
            } else if (stringValue.value != null) {
                n = this.value == stringValue.value ? 0 : this.value.compareTo(stringValue.value);
            }
            return n;
        }

        public String toString() {
            String string = this.isComplement ? "<complement>" : (this.value == null ? "null" : '\"' + this.value + '\"');
            return string;
        }
    }
}

