/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.cfa.spatial.polyhedra;

import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIncompatibleDimensionException;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdIntegerVector;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdOverflowException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.TreeSet;

public class NdIntegerMatrix {
    protected long[][] elements;
    protected int _numRows;
    protected int _numCols;

    NdIntegerMatrix(long[][] lArray, int n, int n2) {
        NdBaseObject.advAssert((lArray.length > 0 && n2 <= lArray[0].length ? 1 : 0) != 0);
        this.elements = lArray;
        this._numCols = n2;
        this._numRows = 0;
    }

    public NdIntegerMatrix(int n, int n2) {
        NdBaseObject.advAssert((n > 0 && n2 > 0 ? 1 : 0) != 0);
        this.elements = new long[n][n2];
        this._numCols = n2;
        this._numRows = 0;
    }

    public void reallocate(int n, int n2) {
        this.elements = new long[n][n2];
        this._numCols = n2;
        this._numRows = 0;
    }

    public int getNumCols() {
        return this._numCols;
    }

    public int getNumRows() {
        return this._numRows;
    }

    public void setNumRows(int n) {
        this._numRows = n;
    }

    public void setNumCols(int n) {
        NdBaseObject.advAssert((n <= this.elements[0].length ? 1 : 0) != 0);
        this._numCols = n;
    }

    public int getNumAllocatedColumns() {
        return this.elements[0].length;
    }

    public int getNumAllocatedRows() {
        return this.elements.length;
    }

    private void WjIwMiP(long[][] lArray, int n) {
        if (this.elements.length < n) {
            this.elements = new long[n][this._numCols];
        }
        for (int i = 0; i < n; ++i) {
            System.arraycopy(lArray[i], 0, this.elements[i], 0, this._numCols);
        }
    }

    public void copyMatrix(NdIntegerMatrix ndIntegerMatrix, int n) throws NdIncompatibleDimensionException {
        NdBaseObject.advAssertNonNull((Object)ndIntegerMatrix);
        NdBaseObject.advAssert((n <= ndIntegerMatrix.elements.length ? 1 : 0) != 0);
        if (ndIntegerMatrix._numCols != this._numCols) {
            throw new NdIncompatibleDimensionException(this._numCols, ndIntegerMatrix._numCols);
        }
        this.WjIwMiP(ndIntegerMatrix.elements, n);
        this._numRows = n;
    }

    public void copyRow(int n, long[] lArray, int n2) throws NdIncompatibleDimensionException {
        NdBaseObject.advAssertNonNull((Object)lArray);
        if (n2 != this._numCols) {
            throw new NdIncompatibleDimensionException(this._numCols, n2);
        }
        this.checkRowOrExtend(n);
        if (n >= this._numRows) {
            this._numRows = n + 1;
        }
        System.arraycopy(lArray, 0, this.elements[n], 0, n2);
    }

    public void deleteRow(int n) {
        if (n >= 0 && n < this._numRows) {
            if (n < this._numRows - 1) {
                int n2 = n + 1;
                int n3 = n;
                while (n2 < this._numRows) {
                    System.arraycopy(this.elements[n2], 0, this.elements[n3], 0, this._numCols);
                    ++n2;
                    ++n3;
                }
            }
            --this._numRows;
        }
    }

    public void checkRowOrExtend(int n) {
        if (n < 0) {
            throw new NoSuchElementException();
        }
        if (n >= this.elements.length) {
            long[][] lArray = new long[n * 2][this.elements[0].length];
            long[][] lArray2 = this.elements;
            this.elements = lArray;
            this.WjIwMiP(lArray2, lArray2.length);
        }
    }

    public int addRow(long[] lArray, int n) throws NdIncompatibleDimensionException {
        NdBaseObject.advAssertNonNull((Object)lArray);
        if (n != this._numCols) {
            throw new NdIncompatibleDimensionException(this._numCols, n);
        }
        this.appendElements(new long[][]{lArray}, 1, n);
        return this._numRows - 1;
    }

    public void appendElements(long[][] lArray, int n, int n2) throws NdIncompatibleDimensionException {
        NdBaseObject.advAssertNonNull((Object)lArray);
        if (n2 != this._numCols) {
            throw new NdIncompatibleDimensionException(this._numCols, n2);
        }
        int n3 = this._numRows + n;
        this.checkRowOrExtend(n3);
        for (int i = 0; i < n; ++i) {
            System.arraycopy(lArray[i], 0, this.elements[this._numRows + i], 0, this._numCols);
        }
        this._numRows += n;
    }

    public String toString() {
        return this.printMatrix();
    }

    public String printMatrix() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Matrix [").append(this._numRows).append(" x ").append(this._numCols).append("]\n");
        for (int i = 0; i < this._numRows; ++i) {
            for (int j = 0; j < this._numCols; ++j) {
                stringBuffer.append(this.elements[i][j]).append("\t");
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof NdIntegerMatrix) {
            NdIntegerMatrix ndIntegerMatrix = (NdIntegerMatrix)object;
            if (this._numRows == ndIntegerMatrix._numRows && this._numCols == ndIntegerMatrix._numCols) {
                bl = true;
                block0: for (int i = 0; i < this._numRows; ++i) {
                    for (int j = 0; j < this._numCols; ++j) {
                        if (this.elements[i][j] == ndIntegerMatrix.elements[i][j]) continue;
                        bl = false;
                        continue block0;
                    }
                }
            }
        }
        return bl;
    }

    public NdIntegerMatrix sort() {
        TreeSet<WjIwKJG> treeSet = new TreeSet<WjIwKJG>();
        for (int i = 0; i < this._numRows; ++i) {
            treeSet.add(new WjIwKJG(this.elements[i]));
        }
        NdIntegerMatrix ndIntegerMatrix = new NdIntegerMatrix(this._numRows, this._numCols);
        ndIntegerMatrix._numRows = 0;
        Iterator iterator = treeSet.iterator();
        for (int i = 0; i < this._numRows && iterator.hasNext(); ++i) {
            try {
                WjIwKJG wjIwKJG = (WjIwKJG)iterator.next();
                ndIntegerMatrix.addRow(wjIwKJG.WjIwKIF, this._numCols);
                continue;
            }
            catch (NdIncompatibleDimensionException ndIncompatibleDimensionException) {
                // empty catch block
            }
        }
        ndIntegerMatrix._numRows = this._numRows;
        return ndIntegerMatrix;
    }

    final void WjIwMjQ(int n, int n2) {
        long[] lArray = this.elements[n];
        this.elements[n] = this.elements[n2];
        this.elements[n2] = lArray;
    }

    public int gaussElimination(int n, int n2) throws NdOverflowException {
        int n3;
        int n4;
        int n5 = 0;
        int[] nArray = new int[n2];
        for (n4 = 1; n4 <= n2; ++n4) {
            int n6;
            long l;
            for (n3 = n5; n3 < n && this.elements[n3][n4] == 0L; ++n3) {
            }
            if (n3 == n) continue;
            if (n3 != n5) {
                NdIntegerVector.WjIwLEC(this.elements[n5], this.elements[n3], 1, n2);
            }
            if ((l = NdIntegerVector.WjIwLEG(this.elements[n5], 1, n2)) > 1L) {
                for (n6 = 0; n6 < n2; ++n6) {
                    long[] lArray = this.elements[n5];
                    int n7 = n6 + 1;
                    lArray[n7] = lArray[n7] / l;
                }
            }
            if (this.elements[n5][n4] < 0L) {
                for (n6 = 0; n6 < n2; ++n6) {
                    long[] lArray = this.elements[n5];
                    int n8 = n6 + 1;
                    lArray[n8] = lArray[n8] * -1L;
                }
            }
            n6 = n3;
            for (n3 = n6 + 1; n3 < n; ++n3) {
                if (this.elements[n3][n4] == 0L) continue;
                NdIntegerVector.WjIwLEI(this.elements[n3], this.elements[n5], this.elements[n3], n4, n2);
            }
            nArray[n5] = n4;
            ++n5;
        }
        for (n4 = n5 - 1; n4 >= 0; --n4) {
            int n9;
            n3 = nArray[n4];
            for (n9 = 0; n9 < n4; ++n9) {
                if (this.elements[n9][n3] == 0L) continue;
                NdIntegerVector.WjIwLEI(this.elements[n9], this.elements[n4], this.elements[n9], n3, n2);
            }
            for (n9 = n; n9 < this._numRows; ++n9) {
                if (this.elements[n9][n3] == 0L) continue;
                NdIntegerVector.WjIwLEI(this.elements[n9], this.elements[n4], this.elements[n9], n3, n2);
            }
        }
        return n5;
    }

    static class WjIwKJG
    implements Comparable {
        final long[] WjIwKIF;

        public WjIwKJG(long[] lArray) {
            this.WjIwKIF = lArray;
        }

        public int compareTo(Object object) {
            WjIwKJG wjIwKJG = (WjIwKJG)object;
            for (int i = 0; i < this.WjIwKIF.length; ++i) {
                if (this.WjIwKIF[i] < wjIwKJG.WjIwKIF[i]) {
                    return -1;
                }
                if (this.WjIwKIF[i] <= wjIwKJG.WjIwKIF[i]) continue;
                return 1;
            }
            return 0;
        }
    }
}

