/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.dfa.testgen;

import com.blazesoft.objects.java.NdDuration;
import com.blazesoft.objects.java.NdInvalidDurationException;
import com.blazesoft.test.NdAssert;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationException;
import com.blazesoft.verifier.NdVerificationStaticContextImpl;
import com.blazesoft.verifier.cfa.spatial.NdComboShape;
import com.blazesoft.verifier.cfa.spatial.NdConvexShape;
import com.blazesoft.verifier.cfa.spatial.NdHyperCube;
import com.blazesoft.verifier.cfa.spatial.NdShape;
import com.blazesoft.verifier.cfa.spatial.NdShapeException;
import com.blazesoft.verifier.cfa.spatial.NdShapeVisitor;
import com.blazesoft.verifier.cfa.spatial.intervals.NdBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableBooleanInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDateInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableDurationInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableEnumeratedTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableIntegerInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableMoneyInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableRealInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableReferenceTypeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableStringInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeInterval;
import com.blazesoft.verifier.cfa.spatial.intervals.NdVariableTimeStampInterval;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdParametricDef;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedralConstraint;
import com.blazesoft.verifier.cfa.spatial.polyhedra.NdPolyhedron;
import com.blazesoft.verifier.dfa.testgen.NdTestCase;
import com.blazesoft.verifier.dfa.testgen.NdTestCaseElement;
import com.blazesoft.verifier.predicate.NdAbstractFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalAddFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMinusFormula;
import com.blazesoft.verifier.predicate.NdArithmeticalMulFormula;
import com.blazesoft.verifier.predicate.NdBinaryFormula;
import com.blazesoft.verifier.predicate.NdConstantDate;
import com.blazesoft.verifier.predicate.NdConstantDuration;
import com.blazesoft.verifier.predicate.NdConstantEnumeratedItem;
import com.blazesoft.verifier.predicate.NdConstantInteger;
import com.blazesoft.verifier.predicate.NdConstantLogical;
import com.blazesoft.verifier.predicate.NdConstantMoney;
import com.blazesoft.verifier.predicate.NdConstantNull;
import com.blazesoft.verifier.predicate.NdConstantReal;
import com.blazesoft.verifier.predicate.NdConstantString;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdConstantTime;
import com.blazesoft.verifier.predicate.NdConstantTimeStamp;
import com.blazesoft.verifier.predicate.NdFormula;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdLogicalAndFormula;
import com.blazesoft.verifier.predicate.NdLogicalOrFormula;
import com.blazesoft.verifier.predicate.NdOperator;
import com.blazesoft.verifier.predicate.NdRelationalPredicate;
import com.blazesoft.verifier.predicate.NdTimeConstraintBinaryFormula;
import com.blazesoft.verifier.predicate.NdTimeConstraintTernaryFormula;
import com.blazesoft.verifier.predicate.NdTimeConstraintVariable;
import com.blazesoft.verifier.predicate.WjIDdTC;
import com.blazesoft.verifier.prom.NdPromAstNode;
import com.blazesoft.verifier.prom.NdVerificationContext;
import com.blazesoft.verifier.type.NdModelEnumeratedItemType;
import com.blazesoft.verifier.type.NdModelType;
import com.blazesoft.verifier.util.NdnCk;
import java.util.ArrayList;
import java.util.Iterator;

public class NdTestSetGenerator
implements NdShapeVisitor {
    private static final NdDuration WjIRGHD = new NdDuration(NdVerificationStaticContextImpl.getInstance().getCalendar(), 5, 1L);
    private static final NdDuration WjIRGIE = new NdDuration(NdVerificationStaticContextImpl.getInstance().getCalendar(), 13, 1L);
    private final NdVerificationContext WjIRGJF;

    public NdTestSetGenerator(NdVerificationContext ndVerificationContext) {
        this.WjIRGJF = ndVerificationContext;
    }

    private NdTestCase[] WjIRGLH(NdPromAstNode ndPromAstNode, NdShape ndShape) throws NdShapeException {
        NdTestCase[] ndTestCaseArray;
        if (ndShape instanceof NdPolyhedron) {
            ndTestCaseArray = (NdTestCase[])ndShape.accept(this, null);
        } else {
            NdShape[] ndShapeArray = ndShape.getElements();
            NdTestCase[][] ndTestCaseArrayArray = new NdTestCase[ndShapeArray.length][];
            for (int i = 0; i < ndShapeArray.length; ++i) {
                ndTestCaseArrayArray[i] = this.WjIRGLH(ndPromAstNode, ndShapeArray[i]);
            }
            ndTestCaseArray = (NdTestCase[])ndShape.accept(this, ndTestCaseArrayArray);
        }
        for (int i = 0; i < ndTestCaseArray.length; ++i) {
            ndTestCaseArray[i].setBranchConditionNode(ndPromAstNode);
        }
        return ndTestCaseArray;
    }

    public NdTestCase[] generate(NdPromAstNode ndPromAstNode, NdConvexShape ndConvexShape) {
        try {
            NdTestCase[] ndTestCaseArray = ndConvexShape.isUniversum() ? new NdTestCase[]{} : this.WjIRGLH(ndPromAstNode, ndConvexShape);
            return ndTestCaseArray;
        }
        catch (NdShapeException ndShapeException) {
            NdBaseObject.advAssert((boolean)false);
            return null;
        }
    }

    private NdTestCase[] WjIRGMI(NdTestCase[][] ndTestCaseArray) {
        NdTestCase[] ndTestCaseArray2 = null;
        if (ndTestCaseArray.length == 1) {
            ndTestCaseArray2 = ndTestCaseArray[0];
        } else {
            int n = 0;
            for (int i = 0; i < ndTestCaseArray.length; ++i) {
                if (ndTestCaseArray[i].length <= n) continue;
                n = ndTestCaseArray[i].length;
            }
            ArrayList<NdTestCase> arrayList = new ArrayList<NdTestCase>();
            ArrayList<NdTestCaseElement> arrayList2 = new ArrayList<NdTestCaseElement>();
            Iterator iterator = NdnCk.iterator(ndTestCaseArray.length * n, ndTestCaseArray.length);
            while (iterator.hasNext()) {
                int[] nArray = (int[])iterator.next();
                for (int i = 0; i < ndTestCaseArray.length; ++i) {
                    int n2 = nArray[i] % n;
                    int n3 = nArray[i] / n;
                    if (n2 >= ndTestCaseArray[n3].length) continue;
                    NdTestCaseElement[] ndTestCaseElementArray = ndTestCaseArray[n3][n2].getElements();
                    for (int j = 0; j < ndTestCaseElementArray.length; ++j) {
                        arrayList2.add(ndTestCaseElementArray[j]);
                    }
                }
                arrayList.add(new NdTestCase(arrayList2.toArray(new NdTestCaseElement[arrayList2.size()])));
                arrayList2.clear();
            }
            ndTestCaseArray2 = arrayList.toArray(new NdTestCase[arrayList.size()]);
        }
        return ndTestCaseArray2;
    }

    public Object visit(NdComboShape ndComboShape, Object object) {
        NdTestCase[][] ndTestCaseArray = (NdTestCase[][])object;
        NdBaseObject.advAssert((ndTestCaseArray.length == 1 || ndTestCaseArray.length == 2 ? 1 : 0) != 0);
        return this.WjIRGMI(ndTestCaseArray);
    }

    public Object visit(NdHyperCube ndHyperCube, Object object) {
        return this.WjIRGMI((NdTestCase[][])object);
    }

    public Object visit(NdPolyhedron ndPolyhedron, Object object) {
        NdParametricDef ndParametricDef = ndPolyhedron.getGenerators();
        ArrayList<NdParametricDef.Generator> arrayList = new ArrayList<NdParametricDef.Generator>();
        int n = ndParametricDef.getNumRows();
        for (int i = 0; i < n; ++i) {
            NdParametricDef.Generator generator = ndParametricDef.getGenerator(i);
            if (!generator.isVertex()) continue;
            arrayList.add(generator);
        }
        NdTestCase[] ndTestCaseArray = new NdTestCase[arrayList.size()];
        WjIDdTC[] wjIDdTCArray = new WjIDdTC[ndPolyhedron.getBasis().getDimension()];
        for (int i = 0; i < wjIDdTCArray.length; ++i) {
            wjIDdTCArray[i] = ndPolyhedron.getBasis().getVariable(i);
        }
        NdModelType ndModelType = this.WjIRGRN(wjIDdTCArray);
        for (int i = 0; i < ndTestCaseArray.length; ++i) {
            NdParametricDef.Generator generator = (NdParametricDef.Generator)arrayList.get(i);
            NdTestCaseElement[] ndTestCaseElementArray = new NdTestCaseElement[ndParametricDef.getDimension()];
            double[] dArray = generator.getCoefficients();
            for (int j = 0; j < ndTestCaseElementArray.length; ++j) {
                ndTestCaseElementArray[j] = new NdTestCaseElement(ndPolyhedron.getBasis().getVariable(j), this.WjIRGNJ(this.WjIRGJF, ndModelType, dArray[j]));
            }
            ndTestCaseArray[i] = new NdTestCase(ndTestCaseElementArray);
        }
        return ndTestCaseArray;
    }

    private NdConstantTerm WjIRGNJ(NdVerificationContext ndVerificationContext, NdModelType ndModelType, double d) {
        NdConstantTerm ndConstantTerm;
        if (ndModelType == NdConstantReal.WjIDgkX) {
            ndConstantTerm = new NdConstantReal(d);
        } else if (ndModelType == NdConstantInteger.WjICYZG) {
            ndConstantTerm = (double)((long)d) == d ? new NdConstantInteger((long)d) : ((double)((long)d) < d ? new NdConstantInteger((long)d + 1L) : new NdConstantInteger((long)d - 1L));
        } else if (ndModelType == NdConstantMoney.WjIDgFP) {
            ndConstantTerm = new NdConstantMoney(ndVerificationContext.getCurrencyManager().getDefaultMappingCurrency().amount(d));
        } else if (ndModelType == NdConstantDuration.WjIDgSE) {
            ndConstantTerm = new NdConstantDuration((long)d);
        } else if (ndModelType == NdConstantTimeStamp.WjIDiZZ) {
            ndConstantTerm = NdConstantTimeStamp.WjIDjgG((long)d);
        } else if (ndModelType == NdConstantTime.WjIDihH) {
            ndConstantTerm = NdConstantTime.WjIDihO((long)d);
        } else if (ndModelType == NdConstantDate.WjIDiPY) {
            ndConstantTerm = NdConstantDate.WjIDiWG((long)d);
        } else {
            NdBaseObject.advAssert((boolean)false);
            ndConstantTerm = null;
        }
        return ndConstantTerm;
    }

    private NdConstantTerm WjIRGOK(NdVerificationContext ndVerificationContext, NdModelType ndModelType, double d) {
        NdConstantTerm ndConstantTerm = ndModelType == NdConstantInteger.WjICYZG ? ((double)((long)d) == d ? new NdConstantInteger((long)d) : new NdConstantReal(d)) : new NdConstantReal(d);
        return ndConstantTerm;
    }

    private NdFormula WjIRGPL(WjIDdTC wjIDdTC, NdTimeInterval ndTimeInterval) throws NdFormulaException {
        NdConstantTime ndConstantTime = ndTimeInterval.getLeftBound();
        boolean bl = ndTimeInterval.isLeftOpen();
        NdConstantTime ndConstantTime2 = ndTimeInterval.getRightBound();
        boolean bl2 = ndTimeInterval.isRightOpen();
        try {
            if (bl && !ndTimeInterval.isLeftInfinite()) {
                ndConstantTime = new NdConstantTime(ndConstantTime.WjIDihQ().add(WjIRGIE));
            }
            if (bl2 && !ndTimeInterval.isRightInfinite()) {
                ndConstantTime2 = new NdConstantTime(ndConstantTime2.WjIDihQ().subtract(WjIRGIE));
            }
        }
        catch (NdInvalidDurationException ndInvalidDurationException) {
            NdAssert.fail((String)("Error building effective time constraint expression:" + ndInvalidDurationException.getMessage()));
        }
        NdAbstractFormula ndAbstractFormula = ndTimeInterval.isLeftMin() || ndTimeInterval.isLeftInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIRGJF, NdOperator.WjICYSG, (WjIDdTC)NdTimeConstraintVariable.WjIDfHT, ndConstantTime2) : (ndTimeInterval.isRightMax() || ndTimeInterval.isRightInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIRGJF, NdOperator.WjICYSF, (WjIDdTC)NdTimeConstraintVariable.WjIDfHT, ndConstantTime) : (ndConstantTime == ndConstantTime2 ? new NdTimeConstraintTernaryFormula(this.WjIRGJF, wjIDdTC, ndConstantTime, ndConstantTime2) : new NdTimeConstraintTernaryFormula(this.WjIRGJF, wjIDdTC, ndConstantTime, ndConstantTime2)));
        return ndAbstractFormula;
    }

    private NdFormula WjIRGQM(WjIDdTC wjIDdTC, NdDateInterval ndDateInterval) throws NdFormulaException {
        NdConstantDate ndConstantDate = ndDateInterval.getLeftBound();
        boolean bl = ndDateInterval.isLeftOpen();
        NdConstantDate ndConstantDate2 = ndDateInterval.getRightBound();
        boolean bl2 = ndDateInterval.isRightOpen();
        try {
            if (bl && !ndDateInterval.isLeftInfinite()) {
                ndConstantDate = new NdConstantDate(ndConstantDate.WjIDiXH().add(WjIRGHD));
            }
            if (bl2 && !ndDateInterval.isRightInfinite()) {
                ndConstantDate2 = new NdConstantDate(ndConstantDate2.WjIDiXH().subtract(WjIRGHD));
            }
        }
        catch (NdInvalidDurationException ndInvalidDurationException) {
            NdAssert.fail((String)("Error building effective date constraint expression:" + ndInvalidDurationException.getMessage()));
        }
        NdAbstractFormula ndAbstractFormula = ndDateInterval.isLeftMin() || ndDateInterval.isLeftInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIRGJF, NdOperator.WjICYSG, (WjIDdTC)NdTimeConstraintVariable.WjIDfGS, ndConstantDate2) : (ndDateInterval.isRightMax() || ndDateInterval.isRightInfinite() ? new NdTimeConstraintBinaryFormula(this.WjIRGJF, NdOperator.WjICYSF, (WjIDdTC)NdTimeConstraintVariable.WjIDfGS, ndConstantDate) : (ndConstantDate == ndConstantDate2 ? new NdTimeConstraintTernaryFormula(this.WjIRGJF, wjIDdTC, ndConstantDate, ndConstantDate2) : new NdTimeConstraintTernaryFormula(this.WjIRGJF, wjIDdTC, ndConstantDate, ndConstantDate2)));
        return ndAbstractFormula;
    }

    private NdModelType WjIRGRN(WjIDdTC[] wjIDdTCArray) {
        NdModelType ndModelType = wjIDdTCArray[0].WjICXCU();
        if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfGS) {
            ndModelType = NdConstantDate.WjIDiPY;
        } else if (wjIDdTCArray[0] == NdTimeConstraintVariable.WjIDfHT) {
            ndModelType = NdConstantTime.WjIDihH;
        }
        try {
            for (int i = 1; i < wjIDdTCArray.length; ++i) {
                if (wjIDdTCArray[i] == null) continue;
                NdModelType ndModelType2 = wjIDdTCArray[i].WjICXCU();
                if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfGS) {
                    ndModelType2 = NdConstantDate.WjIDiPY;
                } else if (wjIDdTCArray[i] == NdTimeConstraintVariable.WjIDfHT) {
                    ndModelType2 = NdConstantTime.WjIDihH;
                }
                ndModelType = this.WjIRGJF.deriveBinaryExpressionType(NdOperator.WjICYPX, ndModelType, ndModelType2, true);
            }
        }
        catch (NdVerificationException ndVerificationException) {
            NdBaseObject.advAssert((boolean)false);
        }
        return ndModelType;
    }

    NdFormula WjIRGSO(double d, WjIDdTC wjIDdTC) throws NdFormulaException {
        NdFormula ndFormula = d == 1.0 ? wjIDdTC : (d == -1.0 ? new NdArithmeticalMinusFormula(this.WjIRGJF, wjIDdTC) : new NdArithmeticalMulFormula(this.WjIRGJF, this.WjIRGOK(this.WjIRGJF, wjIDdTC.WjIDbjU, Math.abs(d)), wjIDdTC));
        return ndFormula;
    }

    public Object visit(NdPolyhedralConstraint ndPolyhedralConstraint, Object object) {
        NdRelationalPredicate ndRelationalPredicate;
        double[] dArray = ndPolyhedralConstraint.getCoefficients();
        WjIDdTC[] wjIDdTCArray = ndPolyhedralConstraint.getVariables();
        NdOperator ndOperator = ndPolyhedralConstraint.getOperator();
        NdModelType ndModelType = this.WjIRGRN(wjIDdTCArray);
        try {
            int n = dArray.length - 1;
            NdFormula ndFormula = wjIDdTCArray[n] != null ? this.WjIRGSO(dArray[n], wjIDdTCArray[n]) : this.WjIRGNJ(this.WjIRGJF, ndModelType, dArray[n]);
            NdFormula ndFormula2 = this.WjIRGSO(dArray[--n], wjIDdTCArray[n]);
            --n;
            while (n >= 0) {
                NdFormula ndFormula3 = this.WjIRGSO(dArray[n], wjIDdTCArray[n]);
                ndFormula2 = new NdArithmeticalAddFormula(this.WjIRGJF, ndFormula3, ndFormula2);
                --n;
            }
            ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, ndOperator, ndFormula2, ndFormula);
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndRelationalPredicate = null;
        }
        return ndRelationalPredicate;
    }

    public Object visit(NdVariableBooleanInterval ndVariableBooleanInterval, Object object) {
        WjIDdTC wjIDdTC = ndVariableBooleanInterval.getVariable();
        NdBooleanInterval ndBooleanInterval = (NdBooleanInterval)ndVariableBooleanInterval.getInterval();
        NdTestCaseElement[] ndTestCaseElementArray = new NdTestCaseElement[]{new NdTestCaseElement(wjIDdTC, ndBooleanInterval == NdBooleanInterval.TRUE ? NdConstantLogical.WjIDcyH : NdConstantLogical.WjIDczI)};
        return new NdTestCase[]{new NdTestCase(ndTestCaseElementArray)};
    }

    public Object visit(NdVariableEnumeratedTypeInterval ndVariableEnumeratedTypeInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableEnumeratedTypeInterval.getVariable();
        NdModelEnumeratedItemType[] ndModelEnumeratedItemTypeArray = ndVariableEnumeratedTypeInterval.getIntervalValue();
        try {
            if (ndModelEnumeratedItemTypeArray.length == 1) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[0]));
            } else {
                int n = ndModelEnumeratedItemTypeArray.length - 1;
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                ndBinaryFormula = new NdLogicalOrFormula(this.WjIRGJF, ndRelationalPredicate2, ndRelationalPredicate);
                while (n >= 0) {
                    NdRelationalPredicate ndRelationalPredicate3 = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, new NdConstantEnumeratedItem(ndModelEnumeratedItemTypeArray[n--]));
                    ndBinaryFormula = new NdLogicalOrFormula(this.WjIRGJF, ndRelationalPredicate3, ndBinaryFormula);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableIntegerInterval ndVariableIntegerInterval, Object object) {
        WjIDdTC wjIDdTC = ndVariableIntegerInterval.getVariable();
        NdIntegerInterval ndIntegerInterval = (NdIntegerInterval)ndVariableIntegerInterval.getInterval();
        long l = ndIntegerInterval.getLeftBound();
        boolean bl = ndIntegerInterval.isLeftOpen();
        long l2 = ndIntegerInterval.getRightBound();
        boolean bl2 = ndIntegerInterval.isRightOpen();
        NdTestCase[] ndTestCaseArray = l == Long.MIN_VALUE ? new NdTestCase[]{new NdTestCase(new NdTestCaseElement(wjIDdTC, bl2 ? new NdConstantInteger(l2 - 1L) : new NdConstantInteger(l2)))} : (l2 == Long.MAX_VALUE ? new NdTestCase[]{new NdTestCase(new NdTestCaseElement(wjIDdTC, bl ? new NdConstantInteger(l + 1L) : new NdConstantInteger(l)))} : (l == l2 && !bl && !bl2 ? new NdTestCase[]{new NdTestCase(new NdTestCaseElement(wjIDdTC, new NdConstantInteger(l2)))} : new NdTestCase[]{new NdTestCase(new NdTestCaseElement(wjIDdTC, bl2 ? new NdConstantInteger(l2 - 1L) : new NdConstantInteger(l2), bl ? new NdConstantInteger(l + 1L) : new NdConstantInteger(l)))}));
        return ndTestCaseArray;
    }

    public Object visit(NdVariableRealInterval ndVariableRealInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableRealInterval.getVariable();
        NdRealInterval ndRealInterval = (NdRealInterval)ndVariableRealInterval.getInterval();
        double d = ndRealInterval.getLeftBound();
        boolean bl = ndRealInterval.isLeftOpen();
        double d2 = ndRealInterval.getRightBound();
        boolean bl2 = ndRealInterval.isRightOpen();
        try {
            if (d == Double.NEGATIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantReal(d2));
            } else if (d2 == Double.POSITIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantReal(d));
            } else if (d == d2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, new NdConstantReal(d));
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, new NdConstantReal(d));
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, new NdConstantReal(d2));
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableMoneyInterval ndVariableMoneyInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableMoneyInterval.getVariable();
        NdMoneyInterval ndMoneyInterval = (NdMoneyInterval)ndVariableMoneyInterval.getInterval();
        NdConstantMoney ndConstantMoney = ndMoneyInterval.getLeftBound();
        boolean bl = ndMoneyInterval.isLeftOpen();
        NdConstantMoney ndConstantMoney2 = ndMoneyInterval.getRightBound();
        boolean bl2 = ndMoneyInterval.isRightOpen();
        try {
            if (ndConstantMoney.WjIDgFT() == Double.NEGATIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantMoney2);
            } else if (ndConstantMoney2.WjIDgFT() == Double.POSITIVE_INFINITY) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantMoney);
            } else if (ndConstantMoney.equals(ndConstantMoney2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantMoney);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantMoney);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantMoney2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableDateInterval ndVariableDateInterval, Object object) {
        NdFormula ndFormula;
        WjIDdTC wjIDdTC = ndVariableDateInterval.getVariable();
        try {
            if (wjIDdTC.WjIDbmX()) {
                ndFormula = this.WjIRGQM(wjIDdTC, (NdDateInterval)ndVariableDateInterval.getInterval());
            } else {
                NdDateInterval ndDateInterval = (NdDateInterval)ndVariableDateInterval.getInterval();
                NdConstantDate ndConstantDate = ndDateInterval.getLeftBound();
                boolean bl = ndDateInterval.isLeftOpen();
                NdConstantDate ndConstantDate2 = ndDateInterval.getRightBound();
                boolean bl2 = ndDateInterval.isRightOpen();
                if (ndConstantDate.equals(ndConstantDate2) && !bl && !bl2) {
                    ndFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantDate);
                } else if (ndConstantDate == NdConstantDate.WjIDiQA) {
                    ndFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDate2);
                } else if (ndConstantDate2 == NdConstantDate.WjIDiPZ) {
                    ndFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDate);
                } else if (ndConstantDate == ndConstantDate2 && !bl && !bl2) {
                    ndFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantDate);
                } else {
                    NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDate);
                    NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDate2);
                    ndFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
                }
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndFormula = null;
        }
        return ndFormula;
    }

    public Object visit(NdVariableTimeStampInterval ndVariableTimeStampInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableTimeStampInterval.getVariable();
        NdTimeStampInterval ndTimeStampInterval = (NdTimeStampInterval)ndVariableTimeStampInterval.getInterval();
        NdConstantTimeStamp ndConstantTimeStamp = ndTimeStampInterval.getLeftBound();
        boolean bl = ndTimeStampInterval.isLeftOpen();
        NdConstantTimeStamp ndConstantTimeStamp2 = ndTimeStampInterval.getRightBound();
        boolean bl2 = ndTimeStampInterval.isRightOpen();
        try {
            if (ndConstantTimeStamp.equals(ndConstantTimeStamp2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantTimeStamp);
            } else if (ndConstantTimeStamp == NdConstantTimeStamp.WjIDjbB) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTimeStamp2);
            } else if (ndConstantTimeStamp2 == NdConstantTimeStamp.WjIDjaA) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTimeStamp);
            } else if (ndConstantTimeStamp == ndConstantTimeStamp2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantTimeStamp);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTimeStamp);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTimeStamp2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableDurationInterval ndVariableDurationInterval, Object object) {
        NdBinaryFormula ndBinaryFormula;
        WjIDdTC wjIDdTC = ndVariableDurationInterval.getVariable();
        NdDurationInterval ndDurationInterval = (NdDurationInterval)ndVariableDurationInterval.getInterval();
        NdConstantDuration ndConstantDuration = ndDurationInterval.getLeftBound();
        boolean bl = ndDurationInterval.isLeftOpen();
        NdConstantDuration ndConstantDuration2 = ndDurationInterval.getRightBound();
        boolean bl2 = ndDurationInterval.isRightOpen();
        try {
            if (ndConstantDuration.equals(ndConstantDuration2) && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantDuration);
            } else if (ndConstantDuration == NdConstantDuration.WjIDgVH) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDuration2);
            } else if (ndConstantDuration2 == NdConstantDuration.WjIDgTF) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDuration);
            } else if (ndConstantDuration == ndConstantDuration2 && !bl && !bl2) {
                ndBinaryFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantDuration);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantDuration);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantDuration2);
                ndBinaryFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndBinaryFormula = null;
        }
        return ndBinaryFormula;
    }

    public Object visit(NdVariableTimeInterval ndVariableTimeInterval, Object object) {
        NdFormula ndFormula;
        WjIDdTC wjIDdTC = ndVariableTimeInterval.getVariable();
        NdTimeInterval ndTimeInterval = (NdTimeInterval)ndVariableTimeInterval.getInterval();
        NdConstantTime ndConstantTime = ndTimeInterval.getLeftBound();
        boolean bl = ndTimeInterval.isLeftOpen();
        NdConstantTime ndConstantTime2 = ndTimeInterval.getRightBound();
        boolean bl2 = ndTimeInterval.isRightOpen();
        try {
            if (wjIDdTC.WjIDbmX()) {
                ndFormula = this.WjIRGPL(wjIDdTC, (NdTimeInterval)ndVariableTimeInterval.getInterval());
            } else if (ndConstantTime.equals(ndConstantTime2) && !bl && !bl2) {
                ndFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantTime);
            } else if (ndConstantTime == NdConstantTime.WjIDihL) {
                ndFormula = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTime2);
            } else if (ndConstantTime2 == NdConstantTime.WjIDihK) {
                ndFormula = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTime);
            } else if (ndConstantTime == ndConstantTime2 && !bl && !bl2) {
                ndFormula = new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, ndConstantTime);
            } else {
                NdRelationalPredicate ndRelationalPredicate = new NdRelationalPredicate(this.WjIRGJF, bl ? NdOperator.WjICYSE : NdOperator.WjICYSF, wjIDdTC, ndConstantTime);
                NdRelationalPredicate ndRelationalPredicate2 = new NdRelationalPredicate(this.WjIRGJF, bl2 ? NdOperator.WjICYSD : NdOperator.WjICYSG, wjIDdTC, ndConstantTime2);
                ndFormula = new NdLogicalAndFormula(this.WjIRGJF, ndRelationalPredicate, ndRelationalPredicate2);
            }
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndFormula = null;
        }
        return ndFormula;
    }

    public Object visit(NdVariableReferenceTypeInterval ndVariableReferenceTypeInterval, Object object) {
        NdRelationalPredicate ndRelationalPredicate;
        try {
            WjIDdTC wjIDdTC = ndVariableReferenceTypeInterval.getVariable();
            NdReferenceTypeInterval ndReferenceTypeInterval = (NdReferenceTypeInterval)ndVariableReferenceTypeInterval.getInterval();
            ndRelationalPredicate = ndReferenceTypeInterval == NdReferenceTypeInterval.NULL ? new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSH, wjIDdTC, NdConstantNull.WjIDeLB) : new NdRelationalPredicate(this.WjIRGJF, NdOperator.WjICYSI, wjIDdTC, NdConstantNull.WjIDeLB);
        }
        catch (NdFormulaException ndFormulaException) {
            NdBaseObject.advAssert((boolean)false);
            ndRelationalPredicate = null;
        }
        return ndRelationalPredicate;
    }

    public Object visit(NdVariableStringInterval ndVariableStringInterval, Object object) {
        WjIDdTC wjIDdTC = ndVariableStringInterval.getVariable();
        NdStringInterval ndStringInterval = (NdStringInterval)ndVariableStringInterval.getInterval();
        NdStringInterval.StringValue[] stringValueArray = ndStringInterval.getElements();
        int n = stringValueArray.length;
        NdTestCaseElement[] ndTestCaseElementArray = new NdTestCaseElement[n];
        int n2 = 0;
        for (int i = 0; i < ndTestCaseElementArray.length; ++i) {
            ndTestCaseElementArray[n2++] = !stringValueArray[i].isComplement ? new NdTestCaseElement(wjIDdTC, new NdConstantString(stringValueArray[i].value)) : new NdTestCaseElement(wjIDdTC, new NdConstantString("---"));
        }
        return new NdTestCase[]{new NdTestCase(ndTestCaseElementArray)};
    }
}

