/*
 * Decompiled with CFR 0.152.
 */
package com.blazesoft.verifier.predicate;

import com.blazesoft.objects.java.NdCurrency;
import com.blazesoft.objects.java.NdMoneyAmount;
import com.blazesoft.util.NdBaseObject;
import com.blazesoft.verifier.NdVerificationStaticContextImpl;
import com.blazesoft.verifier.predicate.NdConstantTerm;
import com.blazesoft.verifier.predicate.NdFormulaErrors;
import com.blazesoft.verifier.predicate.NdFormulaException;
import com.blazesoft.verifier.predicate.NdFormulaVisitor;
import com.blazesoft.verifier.type.NdModelType;
import java.text.ParseException;

public class NdConstantMoney
extends NdConstantTerm
implements NdFormulaErrors {
    private static final NdConstantMoney WjIvReK = new NdConstantMoney(Double.NEGATIVE_INFINITY);
    private static final NdConstantMoney WjIvRfL = new NdConstantMoney(Double.POSITIVE_INFINITY);
    public static final String WjIDgFO = "Constant term";
    public static final NdModelType WjIDgFP = NdVerificationStaticContextImpl.getInstance().getMoneyType();
    public static final NdConstantMoney WjIDgFQ = new NdConstantMoney(0.0);
    private int WjIpgIF;
    private NdMoneyAmount WjIrEIX;
    private NdCurrency WjIvRgM;
    private double WjIrEIY;

    public static NdConstantMoney WjIDgFR() {
        return WjIvRfL;
    }

    public static NdConstantMoney WjIDgFS() {
        return WjIvReK;
    }

    private NdConstantMoney(double d) {
        this.WjIvRgM = NdVerificationStaticContextImpl.getInstance().getCurrencyManager().getDefaultMappingCurrency();
        this.WjIrEIY = d;
        if (d != Double.NEGATIVE_INFINITY && d != Double.POSITIVE_INFINITY) {
            this.WjIrEIX = this.WjIvRgM.amount(d);
            this.WjIpgIF = this.WjIrEIX.hashCode();
        }
    }

    public NdConstantMoney(NdCurrency ndCurrency, double d) {
        this.WjIrEIX = ndCurrency.amount(d);
        this.WjIrEIY = this.WjIrEIX.getValue();
        this.WjIpgIF = this.WjIrEIX.hashCode();
    }

    public NdConstantMoney(NdMoneyAmount ndMoneyAmount) {
        NdBaseObject.advAssertNonNull((Object)ndMoneyAmount);
        this.WjIrEIX = ndMoneyAmount;
        this.WjIrEIY = this.WjIrEIX.getValue();
        this.WjIvRgM = this.WjIrEIX.getCurrency();
        this.WjIpgIF = ndMoneyAmount.hashCode();
    }

    public Object WjICXvN(NdFormulaVisitor ndFormulaVisitor, Object object) throws NdFormulaException {
        return ndFormulaVisitor.visit(this, object);
    }

    public Object WjICZcB() {
        if (this.WjIrEIX == null) {
            throw NdBaseObject.apiError((String)"Attempt to get value of infinite money amount");
        }
        return this.WjIrEIX;
    }

    public double WjIDgFT() {
        return this.WjIrEIY;
    }

    public NdCurrency WjIDgFU() {
        return this.WjIvRgM;
    }

    public boolean WjICZaX() {
        return this.WjIrEIY == Double.POSITIVE_INFINITY;
    }

    public NdConstantTerm WjICZbA() {
        return WjIvRfL;
    }

    public boolean WjICZaW() {
        return this.WjIrEIY == Double.NEGATIVE_INFINITY;
    }

    public NdConstantTerm WjICZaZ() {
        return WjIvReK;
    }

    public boolean WjICZaV() {
        return this.WjIrEIY == 0.0;
    }

    public NdConstantTerm WjICZaY() {
        return WjIDgFQ;
    }

    public NdMoneyAmount WjIDgFV() {
        return this.WjIrEIX;
    }

    public static NdConstantMoney WjIDgFW(String string) throws NdFormulaException {
        try {
            return new NdConstantMoney(NdVerificationStaticContextImpl.getInstance().getCurrencyManager().parse(string));
        }
        catch (ParseException parseException) {
            throw new NdFormulaException("MoneyIllegalFormat", string, (Throwable)parseException);
        }
    }

    public static NdConstantMoney WjIDgFX(double d, String string) throws NdFormulaException {
        try {
            return new NdConstantMoney(NdVerificationStaticContextImpl.getInstance().getCurrencyManager().parse(Double.toString(d) + ' ' + string));
        }
        catch (ParseException parseException) {
            throw new NdFormulaException("MoneyIllegalFormat", string, (Throwable)parseException);
        }
    }

    public NdModelType WjICXCU() {
        return WjIDgFP;
    }

    public boolean equals(Object object) {
        return object == this || object != null && object instanceof NdConstantMoney && ((NdConstantMoney)object).WjIrEIY == this.WjIrEIY;
    }

    public int hashCode() {
        return this.WjIpgIF;
    }

    public String toString() {
        return this.WjIrEIX == null ? "0" : this.WjIrEIX.toString();
    }
}

