/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.tartarus.snowball.ext.SpanishStemmer;

public class SpanishStemFilter
extends TokenFilter {
    private SpanishStemmer stemmer = new SpanishStemmer();
    private Token token = null;

    public SpanishStemFilter(TokenStream in) {
        super(in);
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        this.stemmer.setCurrent(this.token.termText());
        this.stemmer.stem();
        String s = this.stemmer.getCurrent();
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(SpanishStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }
}

