/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.bean.Bookmark;
import com.openkm.module.BookmarkModule;
import com.openkm.module.ModuleManager;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMBookmark
implements BookmarkModule {
    private static Logger log = LoggerFactory.getLogger(OKMBookmark.class);
    private static OKMBookmark instance = new OKMBookmark();

    private OKMBookmark() {
    }

    public static OKMBookmark getInstance() {
        return instance;
    }

    @Override
    public Bookmark add(String token, String nodePath, String name) throws AccessDeniedException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("add({}, {}, {})", new Object[]{token, nodePath, name});
        BookmarkModule bm = ModuleManager.getBookmarkModule();
        Bookmark bookmark = bm.add(token, nodePath, name);
        log.debug("add: {}", (Object)bookmark);
        return bookmark;
    }

    @Override
    public Bookmark get(String token, int bmId) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("get({}, {})", new Object[]{token, bmId});
        BookmarkModule bm = ModuleManager.getBookmarkModule();
        Bookmark bookmark = bm.get(token, bmId);
        log.debug("get: {}", (Object)bookmark);
        return bookmark;
    }

    @Override
    public void remove(String token, int bmId) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("remove({}, {})", (Object)token, (Object)bmId);
        BookmarkModule bm = ModuleManager.getBookmarkModule();
        bm.remove(token, bmId);
        log.debug("remove: void");
    }

    @Override
    public Bookmark rename(String token, int bmId, String newName) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, bmId, newName});
        BookmarkModule bm = ModuleManager.getBookmarkModule();
        Bookmark bookmark = bm.rename(token, bmId, newName);
        log.debug("rename: {}", (Object)bookmark);
        return bookmark;
    }

    @Override
    public List<Bookmark> getAll(String token) throws RepositoryException, DatabaseException {
        log.debug("getAll({})", (Object)token);
        BookmarkModule bm = ModuleManager.getBookmarkModule();
        List<Bookmark> col = bm.getAll(token);
        log.debug("getAll: {}", col);
        return col;
    }
}

