/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.bean.Document;
import com.openkm.bean.Document2;
import com.openkm.bean.DocumentHash;
import com.openkm.bean.Lock;
import com.openkm.bean.Version;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.FileSizeExceededException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UnsupportedMimeTypeException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VersionException;
import com.openkm.core.VirusDetectedException;
import com.openkm.extension.core.ExtensionException;
import com.openkm.module.DocumentModule;
import com.openkm.module.ModuleManager;
import com.openkm.principal.PrincipalAdapterException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMDocument
implements DocumentModule {
    private static Logger log = LoggerFactory.getLogger(OKMDocument.class);
    private static OKMDocument instance = new OKMDocument();

    private OKMDocument() {
    }

    public static OKMDocument getInstance() {
        return instance;
    }

    @Override
    public Document create(String token, Document doc, InputStream is) throws UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("create({}, {}, {})", new Object[]{token, doc, is});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document newDocument = dm.create(token, doc, is);
        log.debug("create: {}", (Object)newDocument);
        return newDocument;
    }

    public Document createSimple(String token, String docPath, InputStream is) throws UnsupportedMimeTypeException, FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("createSimple({}, {}, {})", new Object[]{token, docPath, is});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document doc = new Document();
        doc.setPath(docPath);
        Document newDocument = dm.create(token, doc, is);
        log.debug("createSimple: {}", (Object)newDocument);
        return newDocument;
    }

    @Override
    public void delete(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("delete({})", (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.delete(token, docPath);
        log.debug("delete: void");
    }

    @Override
    public Document getProperties(String token, String docPath) throws RepositoryException, PathNotFoundException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document doc = dm.getProperties(token, docPath);
        log.debug("getProperties: {}", (Object)doc);
        return doc;
    }

    @Override
    public InputStream getContent(String token, String docPath, boolean checkout) throws PathNotFoundException, RepositoryException, IOException, DatabaseException {
        log.debug("getContent({}, {}, {})", new Object[]{token, docPath, checkout});
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream is = dm.getContent(token, docPath, checkout);
        log.debug("getContent: {}", (Object)is);
        return is;
    }

    @Override
    public InputStream getContentByVersion(String token, String docPath, String versionId) throws RepositoryException, PathNotFoundException, IOException, DatabaseException {
        log.debug("getContentByVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        DocumentModule dm = ModuleManager.getDocumentModule();
        InputStream is = dm.getContentByVersion(token, docPath, versionId);
        log.debug("getContentByVersion: {}", (Object)is);
        return is;
    }

    @Override
    public List<Document> getChilds(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds({}, {})", (Object)token, (Object)fldPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document> col = dm.getChilds(token, fldPath);
        log.debug("getChilds: {}", col);
        return col;
    }

    @Override
    public List<Document2> getChilds2(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds2({}, {})", (Object)token, (Object)fldPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> col = dm.getChilds2(token, fldPath);
        log.debug("getChilds2: {}", col);
        return col;
    }

    @Override
    public Document rename(String token, String docPath, String newName) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("rename({}, {})", (Object)docPath, (Object)newName);
        DocumentModule dm = ModuleManager.getDocumentModule();
        Document renamedDocument = dm.rename(token, docPath, newName);
        log.debug("rename: {}", (Object)renamedDocument);
        return renamedDocument;
    }

    @Override
    public void setProperties(String token, Document doc) throws LockException, VersionException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("setProperties({}, {})", (Object)token, (Object)doc);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.setProperties(token, doc);
        log.debug("setProperties: void");
    }

    @Override
    public void checkout(String token, String docPath, Boolean ... lock) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("checkout({}, {}, {})", new Object[]{token, docPath, lock});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.checkout(token, docPath, lock);
        log.debug("checkout: void");
    }

    @Override
    public void cancelCheckout(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("cancelCheckout({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.cancelCheckout(token, docPath);
        log.debug("cancelCheckout: void");
    }

    @Override
    public void forceCancelCheckout(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, PrincipalAdapterException {
        log.debug("forceCancelCheckout({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.forceCancelCheckout(token, docPath);
        log.debug("forceCancelCheckout: void");
    }

    @Override
    public boolean isCheckedOut(String token, String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("isCheckedOut({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        boolean checkedOut = dm.isCheckedOut(token, docPath);
        log.debug("isCheckedOut: {}", (Object)checkedOut);
        return checkedOut;
    }

    @Override
    public Version checkin(String token, String docPath, String comment, Boolean ... unlock) throws LockException, VersionException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("checkin({}, {}, {}, {})", new Object[]{token, docPath, comment, unlock});
        DocumentModule dm = ModuleManager.getDocumentModule();
        Version version = dm.checkin(token, docPath, comment, unlock);
        log.debug("checkin: {}", (Object)version);
        return version;
    }

    @Override
    public List<Version> getVersionHistory(String token, String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getVersionHistory({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Version> history = dm.getVersionHistory(token, docPath);
        log.debug("getVersionHistory: {}", history);
        return history;
    }

    @Override
    public void setContent(String token, String docPath, InputStream is, Long length) throws FileSizeExceededException, UserQuotaExceededException, VirusDetectedException, VersionException, LockException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, ExtensionException {
        log.debug("setContent({}, {}, {}, {})", new Object[]{token, docPath, is, length});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.setContent(token, docPath, is, length);
        log.debug("setContent: void");
    }

    @Override
    public Lock lock(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("lock({})", (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        Lock lock = dm.lock(token, docPath);
        log.debug("lock: {}", (Object)lock);
        return lock;
    }

    @Override
    public void unlock(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unlock({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.unlock(token, docPath);
        log.debug("unlock: void");
    }

    @Override
    public void forceUnlock(String token, String docPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, PrincipalAdapterException {
        log.debug("forceUnlock({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.forceUnlock(token, docPath);
        log.debug("forceUnlock: void");
    }

    @Override
    public boolean isLocked(String token, String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("isLocked({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        boolean locked = dm.isLocked(token, docPath);
        log.debug("isLocked: {}", (Object)locked);
        return locked;
    }

    @Override
    public Lock getLock(String token, String docPath) throws LockException, PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getLock({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        Lock lock = dm.getLock(token, docPath);
        log.debug("getLock: {}", (Object)lock);
        return lock;
    }

    @Override
    public void purge(String token, String docPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("purge({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.purge(token, docPath);
        log.debug("purge: void");
    }

    @Override
    public void move(String token, String docPath, String destPath) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("move({}, {}, {})", new Object[]{token, docPath, destPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.move(token, docPath, destPath);
        log.debug("move: void");
    }

    @Override
    public void copy(String token, String docPath, String destPath) throws ItemExistsException, PathNotFoundException, AccessDeniedException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException, ExtensionException {
        log.debug("copy({}, {}, {})", new Object[]{token, docPath, destPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.copy(token, docPath, destPath);
        log.debug("copy: void");
    }

    @Override
    public void restoreVersion(String token, String docPath, String versionId) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException, ExtensionException {
        log.debug("restoreVersion({}, {}, {})", new Object[]{token, docPath, versionId});
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.restoreVersion(token, docPath, versionId);
        log.debug("restoreVersion: void");
    }

    @Override
    public void purgeVersionHistory(String token, String docPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("purgeVersionHistory({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        dm.purgeVersionHistory(token, docPath);
        log.debug("purgeVersionHistory: void");
    }

    @Override
    public long getVersionHistorySize(String token, String docPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getVersionHistorySize({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        long size = dm.getVersionHistorySize(token, docPath);
        log.debug("getVersionHistorySize: {}", (Object)size);
        return size;
    }

    @Override
    public boolean isValid(String token, String docPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)docPath);
        DocumentModule dm = ModuleManager.getDocumentModule();
        boolean valid = dm.isValid(token, docPath);
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @Override
    public String getPath(String token, String uuid) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({}, {})", (Object)token, (Object)uuid);
        DocumentModule dm = ModuleManager.getDocumentModule();
        String path = dm.getPath(token, uuid);
        log.debug("getPath: {}", (Object)path);
        return path;
    }

    @Override
    public List<Document2> getDocuments(String token, List<DocumentHash> docs, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {}. {})", new Object[]{token, docs, fldPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> result = dm.getDocuments(token, docs, fldPath);
        log.debug("getDocuments: {}", result);
        return result;
    }

    @Override
    public List<Document2> getDocuments(String token, String docsHash, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getDocuments({}, {}. {})", new Object[]{token, docsHash, fldPath});
        DocumentModule dm = ModuleManager.getDocumentModule();
        List<Document2> result = dm.getDocuments(token, docsHash, fldPath);
        log.debug("getDocuments: {}", result);
        return result;
    }
}

