/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.bean.Mail;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.module.MailModule;
import com.openkm.module.ModuleManager;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMMail
implements MailModule {
    private static Logger log = LoggerFactory.getLogger(OKMMail.class);
    private static OKMMail instance = new OKMMail();

    private OKMMail() {
    }

    public static OKMMail getInstance() {
        return instance;
    }

    @Override
    public Mail create(String token, Mail mail) throws PathNotFoundException, ItemExistsException, VirusDetectedException, AccessDeniedException, RepositoryException, DatabaseException, UserQuotaExceededException {
        log.debug("create({}, {})", (Object)token, (Object)mail);
        MailModule mm = ModuleManager.getMailModule();
        Mail newMail = mm.create(token, mail);
        log.debug("create: {}", (Object)newMail);
        return newMail;
    }

    @Override
    public Mail getProperties(String token, String mailPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getProperties({}, {})", (Object)token, (Object)mailPath);
        MailModule mm = ModuleManager.getMailModule();
        Mail mail = mm.getProperties(token, mailPath);
        log.debug("getProperties: {}", (Object)mail);
        return mail;
    }

    @Override
    public void delete(String token, String mailPath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("delete({}, {})", (Object)token, (Object)mailPath);
        MailModule mm = ModuleManager.getMailModule();
        mm.delete(token, mailPath);
        log.debug("delete: void");
    }

    @Override
    public void purge(String token, String mailPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("purge({}, {})", (Object)token, (Object)mailPath);
        MailModule mm = ModuleManager.getMailModule();
        mm.purge(token, mailPath);
        log.debug("purge: void");
    }

    @Override
    public Mail rename(String token, String mailPath, String newName) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("rename({}, {}, {})", new Object[]{token, mailPath, newName});
        MailModule mm = ModuleManager.getMailModule();
        Mail renamedMail = mm.rename(token, mailPath, newName);
        log.debug("rename: {}", (Object)renamedMail);
        return renamedMail;
    }

    @Override
    public void move(String token, String mailPath, String dstPath) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("move({}, {}, {})", new Object[]{token, mailPath, dstPath});
        MailModule mm = ModuleManager.getMailModule();
        mm.move(token, mailPath, dstPath);
        log.debug("move: void");
    }

    @Override
    public void copy(String token, String mailPath, String dstPath) throws PathNotFoundException, ItemExistsException, AccessDeniedException, RepositoryException, IOException, DatabaseException, UserQuotaExceededException {
        log.debug("copy({}, {}, {})", new Object[]{token, mailPath, dstPath});
        MailModule mm = ModuleManager.getMailModule();
        mm.copy(token, mailPath, dstPath);
        log.debug("copy: void");
    }

    @Override
    public List<Mail> getChilds(String token, String fldPath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("getChilds({}, {})", (Object)token, (Object)fldPath);
        MailModule mm = ModuleManager.getMailModule();
        List<Mail> childs = mm.getChilds(token, fldPath);
        log.debug("getChilds: {}", childs);
        return childs;
    }

    @Override
    public boolean isValid(String token, String mailPath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("isValid({}, {})", (Object)token, (Object)mailPath);
        MailModule mm = ModuleManager.getMailModule();
        boolean valid = mm.isValid(token, mailPath);
        log.debug("isValid: {}", (Object)valid);
        return valid;
    }

    @Override
    public String getPath(String token, String uuid) throws AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getPath({})", (Object)uuid);
        MailModule mm = ModuleManager.getMailModule();
        String path = mm.getPath(token, uuid);
        log.debug("getPath: {}", (Object)path);
        return path;
    }
}

