/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.bean.Note;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.LockException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.NoteModule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMNote
implements NoteModule {
    private static Logger log = LoggerFactory.getLogger(OKMNote.class);
    private static OKMNote instance = new OKMNote();

    private OKMNote() {
    }

    public static OKMNote getInstance() {
        return instance;
    }

    @Override
    public Note add(String token, String nodePath, String text) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("add({}, {}, {})", new Object[]{token, nodePath, text});
        NoteModule nm = ModuleManager.getNoteModule();
        Note ret = nm.add(token, nodePath, text);
        log.debug("add: {}", (Object)ret);
        return ret;
    }

    @Override
    public Note get(String token, String notePath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("get({}, {})", (Object)token, (Object)notePath);
        NoteModule nm = ModuleManager.getNoteModule();
        Note ret = nm.get(token, notePath);
        log.debug("get: {}", (Object)ret);
        return ret;
    }

    @Override
    public void remove(String token, String notePath) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("remove({}, {})", (Object)token, (Object)notePath);
        NoteModule nm = ModuleManager.getNoteModule();
        nm.remove(token, notePath);
        log.debug("remove: void");
    }

    @Override
    public void set(String token, String notePath, String text) throws LockException, PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("set({}, {}, {})", new Object[]{token, notePath, text});
        NoteModule nm = ModuleManager.getNoteModule();
        nm.set(token, notePath, text);
        log.debug("set: void");
    }

    @Override
    public List<Note> list(String token, String nodePath) throws PathNotFoundException, RepositoryException, DatabaseException {
        log.debug("list({}, {})", (Object)token, (Object)nodePath);
        NoteModule nm = ModuleManager.getNoteModule();
        List<Note> col = nm.list(token, nodePath);
        log.debug("list: {}", col);
        return col;
    }
}

