/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.NotificationModule;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMNotification
implements NotificationModule {
    private static Logger log = LoggerFactory.getLogger(OKMNotification.class);
    private static OKMNotification instance = new OKMNotification();

    private OKMNotification() {
    }

    public static OKMNotification getInstance() {
        return instance;
    }

    @Override
    public void subscribe(String token, String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("subscribe({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.subscribe(token, nodePath);
        log.debug("subscribe: void");
    }

    @Override
    public void unsubscribe(String token, String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("unsubscribe({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.unsubscribe(token, nodePath);
        log.debug("unsubscribe: void");
    }

    @Override
    public List<String> getSubscriptors(String token, String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getSubscriptors({}, {})", (Object)token, (Object)nodePath);
        NotificationModule nm = ModuleManager.getNotificationModule();
        List<String> users = nm.getSubscriptors(token, nodePath);
        log.debug("getSubscriptors: {}", users);
        return users;
    }

    @Override
    public void notify(String token, String nodePath, List<String> users, String message, boolean attachment) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        log.debug("notify({}, {}, {}, {}, {})", new Object[]{token, nodePath, users, message, attachment});
        NotificationModule nm = ModuleManager.getNotificationModule();
        nm.notify(token, nodePath, users, message, attachment);
        log.debug("notify: void");
    }
}

