/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.api;

import com.openkm.core.AccessDeniedException;
import com.openkm.core.DatabaseException;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.module.ModuleManager;
import com.openkm.module.ScriptingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMScripting
implements ScriptingModule {
    private static Logger log = LoggerFactory.getLogger(OKMScripting.class);
    private static OKMScripting instance = new OKMScripting();

    private OKMScripting() {
    }

    public static OKMScripting getInstance() {
        return instance;
    }

    @Override
    public void setScript(String token, String nodePath, String code) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("setScript({}, {}, {})", new Object[]{token, nodePath, code});
        ScriptingModule sm = ModuleManager.getScriptingModule();
        sm.setScript(token, nodePath, code);
        log.debug("setScript: void");
    }

    @Override
    public void removeScript(String token, String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("removeScript({}, {})", (Object)token, (Object)nodePath);
        ScriptingModule sm = ModuleManager.getScriptingModule();
        sm.removeScript(token, nodePath);
        log.debug("removeScript: void");
    }

    @Override
    public String getScript(String token, String nodePath) throws PathNotFoundException, AccessDeniedException, RepositoryException, DatabaseException {
        log.debug("getScript({}, {})", (Object)token, (Object)nodePath);
        ScriptingModule sm = ModuleManager.getScriptingModule();
        String code = sm.getScript(token, nodePath);
        log.debug("getScript: {}", (Object)code);
        return code;
    }
}

