/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.bean.form;

import com.openkm.bean.form.FormElement;
import com.openkm.bean.form.Option;
import com.openkm.bean.form.Validator;
import com.openkm.dao.KeyValueDAO;
import com.openkm.dao.bean.KeyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
extends FormElement {
    private static Logger log = LoggerFactory.getLogger(Select.class);
    private static final long serialVersionUID = 1L;
    public static final String TYPE_SIMPLE = "simple";
    public static final String TYPE_MULTIPLE = "multiple";
    private List<Validator> validators = new ArrayList<Validator>();
    private List<Option> options = new ArrayList<Option>();
    private String type = "simple";
    private String value = "";
    private String data = "";
    private String optionsData = "";
    private String table = "";
    private String optionsQuery = "";
    private boolean readonly = false;

    public Select() {
        this.width = "150px";
    }

    public List<Option> getOptions() {
        return this.handleDbOptions(this.options);
    }

    public void setOptions(List<Option> options) {
        this.handleDbOptions(options);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Validator> getValidators() {
        return this.validators;
    }

    public void setValidators(List<Validator> validators) {
        this.validators = validators;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getOptionsData() {
        return this.optionsData;
    }

    public void setOptionsData(String optionsData) {
        this.optionsData = optionsData;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getOptionsQuery() {
        return this.optionsQuery;
    }

    public void setOptionsQuery(String optionsQuery) {
        this.optionsQuery = optionsQuery;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("label=").append(this.label);
        sb.append(", name=").append(this.name);
        sb.append(", width=").append(this.width);
        sb.append(", height=").append(this.height);
        sb.append(", readonly=").append(this.readonly);
        sb.append(", type=").append(this.type);
        sb.append(", value=").append(this.value);
        sb.append(", data=").append(this.data);
        sb.append(", optionsData=").append(this.optionsData);
        sb.append(", options=").append(this.options);
        sb.append(", validators=").append(this.validators);
        sb.append(", table=").append(this.table);
        sb.append(", optionsQuery=").append(this.optionsQuery);
        sb.append("}");
        return sb.toString();
    }

    private List<Option> handleDbOptions(List<Option> options) {
        if (this.optionsQuery == null || this.optionsQuery.isEmpty()) {
            this.options = options;
        } else {
            List<Option> dbOptions = this.getOptionsFromDb();
            HashMap<String, Option> hashedOptions = new HashMap<String, Option>();
            if (this.options != null) {
                for (Option option : this.options) {
                    hashedOptions.put(option.getValue(), option);
                }
            }
            for (Option dbOption : dbOptions) {
                if (dbOption == null) continue;
                Option option = (Option)hashedOptions.get(dbOption.getValue());
                dbOption.setSelected(option != null ? option.isSelected() : false);
            }
            this.options = dbOptions;
        }
        return this.options;
    }

    private List<Option> getOptionsFromDb() {
        ArrayList<Option> dbOptions = new ArrayList<Option>();
        try {
            log.debug("Getting options from DB (table={}, query={})", new Object[]{this.table, this.optionsQuery});
            List<KeyValue> keyValues = KeyValueDAO.getKeyValues(this.table, this.optionsQuery);
            for (KeyValue keyValue : keyValues) {
                Option option = new Option();
                option.setValue(keyValue.getKey());
                option.setLabel(keyValue.getValue());
                dbOptions.add(option);
            }
            log.debug("Got {} options from DB", (Object)dbOptions.size());
        }
        catch (Throwable t) {
            log.error("Unable to get key values for Select", t);
        }
        return dbOptions;
    }
}

