/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.bean.kea;

import com.openkm.bean.kea.Term;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class MetadataDTO
implements Serializable {
    private static final long serialVersionUID = 2530668808598426112L;
    private String fileName;
    private String tempFileName;
    private String mimeType = "";
    private String title = "";
    private String creator = "";
    private String generator = "";
    private String keyword = "";
    private int pageCount;
    private List<String> subjects = new ArrayList<String>();
    private Date contentCreated = null;
    private Date contentLastModified = null;

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        if (creator != null) {
            this.creator = creator;
        }
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public List<Term> getSubjectsAsTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        Iterator<String> iter = this.subjects.iterator();
        while (iter.hasNext()) {
            terms.add(new Term("", iter.next()));
        }
        return terms;
    }

    public void setSubjects(List<String> subjects) {
        this.subjects = subjects;
    }

    public void addSubject(String subject) {
        if (subject != null) {
            this.subjects.add(subject);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (fileName != null) {
            this.fileName = fileName;
        }
    }

    public String getTempFileName() {
        return this.tempFileName;
    }

    public void setTempFileName(String tempFileName) {
        if (tempFileName != null) {
            this.tempFileName = tempFileName;
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType != null) {
            this.mimeType = mimeType;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (title != null) {
            this.title = title;
        }
    }

    public String getGenerator() {
        return this.generator;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public Date getContentCreated() {
        if (this.contentCreated != null) {
            return new Date(this.contentCreated.getTime());
        }
        return null;
    }

    public void setContentCreated(Date contentCreated) {
        this.contentCreated = contentCreated != null ? new Date(contentCreated.getTime()) : null;
    }

    public Date getContentLastModified() {
        if (this.contentLastModified != null) {
            return new Date(this.contentLastModified.getTime());
        }
        return null;
    }

    public void setContentLastModified(Date contentLastModified) {
        this.contentLastModified = contentLastModified != null ? new Date(contentLastModified.getTime()) : null;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataDTO that = (MetadataDTO)o;
        if (this.contentCreated != null ? !this.contentCreated.equals(that.contentCreated) : that.contentCreated != null) {
            return false;
        }
        if (this.contentLastModified != null ? !this.contentLastModified.equals(that.contentLastModified) : that.contentLastModified != null) {
            return false;
        }
        if (!this.creator.equals(that.creator)) {
            return false;
        }
        if (!this.fileName.equals(that.fileName)) {
            return false;
        }
        if (!this.mimeType.equals(that.mimeType)) {
            return false;
        }
        if (!((Object)this.subjects).equals(that.subjects)) {
            return false;
        }
        if (!this.tempFileName.equals(that.tempFileName)) {
            return false;
        }
        return this.title.equals(that.title);
    }

    public int hashCode() {
        int result = this.fileName.hashCode();
        result = 31 * result + this.tempFileName.hashCode();
        result = 31 * result + this.mimeType.hashCode();
        result = 31 * result + this.title.hashCode();
        result = 31 * result + this.creator.hashCode();
        result = 31 * result + (this.contentCreated != null ? this.contentCreated.hashCode() : 0);
        result = 31 * result + (this.contentLastModified != null ? this.contentLastModified.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("title=").append(this.title);
        sb.append(", mimeType=").append(this.mimeType);
        sb.append(", fileName=").append(this.fileName);
        sb.append(", tempFileName=").append(this.tempFileName);
        sb.append(", creator=").append(this.creator);
        sb.append(", generator=").append(this.generator);
        sb.append(", keyword=").append(this.keyword);
        sb.append(", pageCount=").append(this.pageCount);
        sb.append(", contentCreated=").append(this.contentCreated == null ? null : Long.valueOf(this.contentCreated.getTime()));
        sb.append(", contentLastModified=").append(this.contentLastModified == null ? null : Long.valueOf(this.contentLastModified.getTime()));
        sb.append(", subjects=").append(this.subjects);
        sb.append("}");
        return sb.toString();
    }
}

