/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.cache;

import com.openkm.bean.cache.NodePermissions;
import com.openkm.cache.NodePermissionsManager;
import com.openkm.core.Config;
import com.openkm.module.direct.DirectRepositoryModule;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(OKMAccessManager.class);
    private static final boolean DEBUG = true;
    private Subject subject = null;
    private HierarchyManager hierMgr = null;
    private String principalUser = null;
    private Set<String> principalRoles = null;

    public void init(AMContext context) throws AccessDeniedException {
        log.info("init(" + context + ")");
        this.subject = context.getSubject();
        this.principalRoles = new HashSet<String>();
        log.info("##### " + this.subject.getPrincipals());
        log.info("##### ##### ##### ##### ##### ##### ##### ");
        for (Principal obj : this.subject.getPrincipals()) {
            log.info("##### " + obj.getClass());
            if (obj instanceof Group) {
                Group group = (Group)obj;
                log.info("Group: " + group.getName());
                Enumeration groups = group.members();
                while (groups.hasMoreElements()) {
                    Principal rol = (Principal)groups.nextElement();
                    log.info("Rol: " + rol.getName());
                    this.principalRoles.add(rol.getName());
                }
                continue;
            }
            if (obj instanceof Principal) {
                Principal principal = obj;
                this.principalUser = principal.getName();
                log.debug("Principal: " + this.principalUser);
                continue;
            }
            if (!(obj instanceof UserPrincipal)) continue;
            UserPrincipal userPrincipal = (UserPrincipal)obj;
            this.principalUser = userPrincipal.getName();
            this.principalRoles.add(Config.DEFAULT_USER_ROLE);
            log.debug("UserPrincipal: " + this.principalUser);
        }
        log.debug("PrincipalUser: " + this.principalUser);
        log.debug("PrincipalRoles: " + this.principalRoles);
        log.debug("##### ##### ##### ##### ##### ##### ##### ");
        this.hierMgr = context.getHierarchyManager();
        log.debug("init: void");
    }

    public void close() throws Exception {
        log.debug("close()");
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        log.debug("checkPermission()");
        log.debug("checkPermission: void");
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        log.debug("isGranted(" + this.subject.getPrincipals() + ", " + id + ", " + (permissions == 1 ? "READ" : (permissions == 2 ? "WRITE" : (permissions == 4 ? "REMOVE" : "NONE"))) + ")");
        boolean access = false;
        if (this.principalRoles.contains(Config.DEFAULT_ADMIN_ROLE)) {
            access = true;
        } else {
            NodeId nodeId = null;
            log.debug(this.subject.getPrincipals() + " Item Id: " + id);
            try {
                log.debug(this.subject.getPrincipals() + " Item Path: " + this.hierMgr.getPath(id));
            }
            catch (ItemNotFoundException e) {
                access = true;
                log.debug(this.subject.getPrincipals() + " hierMgr.getPath() > ItemNotFoundException: " + e.getMessage());
            }
            if (id instanceof NodeId) {
                nodeId = (NodeId)id;
                log.debug(this.subject.getPrincipals() + " This is a NODE");
            } else {
                PropertyId propertyId = (PropertyId)id;
                nodeId = propertyId.getParentId();
                log.debug(this.subject.getPrincipals() + " This is a PROPERTY");
            }
            if (access || this.hierMgr.getPath((ItemId)nodeId).denotesRoot()) {
                access = true;
            } else {
                NodePermissions nPerms = NodePermissionsManager.get(nodeId);
                if (nPerms == null) {
                    Session systemSession = DirectRepositoryModule.getSystemSession();
                    NodeImpl node = null;
                    try {
                        node = ((SessionImpl)systemSession).getNodeById(nodeId);
                    }
                    catch (ItemNotFoundException e1) {
                        log.debug(this.subject.getPrincipals() + " systemSession.getNodeById() > ItemNotFoundException: " + e1.getMessage());
                    }
                    if (node == null) {
                        access = true;
                    } else {
                        String realNodeId;
                        log.debug(this.subject.getPrincipals() + " Node Name: " + node.getPath());
                        log.debug(this.subject.getPrincipals() + " Node Type: " + node.getPrimaryNodeType().getName());
                        if (node.isNodeType("okm:resource")) {
                            log.debug(this.subject.getPrincipals() + " Node is CONTENT_TYPE");
                            node = node.getParent();
                            log.debug(this.subject.getPrincipals() + " Real -> " + node.getPath());
                        } else if (node.isNodeType("okm:notes")) {
                            log.debug(this.subject.getPrincipals() + " Node is NOTE_LIST_TYPE");
                            node = node.getParent();
                            log.debug(this.subject.getPrincipals() + " Real -> " + node.getPath());
                        } else if (node.isNodeType("okm:note")) {
                            log.debug(this.subject.getPrincipals() + " Node is NOTE_TYPE");
                            node = node.getParent().getParent();
                        } else if (node.isNodeType("nt:frozenNode")) {
                            log.debug(this.subject.getPrincipals() + " Node is FROZEN_NODE");
                            realNodeId = node.getProperty("jcr:frozenUuid").getString();
                            node = systemSession.getNodeByUUID(realNodeId).getParent();
                            log.debug(this.subject.getPrincipals() + " Real -> " + node.getPath());
                        } else if (node.isNodeType("nt:version")) {
                            log.debug(this.subject.getPrincipals() + " Node is VERSION");
                            Node frozenNode = node.getNode("jcr:frozenNode");
                            log.debug(this.subject.getPrincipals() + " el congelado -> " + frozenNode.getPath());
                            String realNodeId2 = frozenNode.getProperty("jcr:frozenUuid").getString();
                            try {
                                node = systemSession.getNodeByUUID(realNodeId2).getParent();
                                log.debug(this.subject.getPrincipals() + " Real -> " + node.getPath());
                            }
                            catch (ItemNotFoundException e) {
                                log.debug(this.subject.getPrincipals() + " **************");
                                log.debug(this.subject.getPrincipals() + " -> " + e.getMessage());
                            }
                        } else if (node.isNodeType("nt:versionHistory")) {
                            log.debug(this.subject.getPrincipals() + " Node is VERSION_HISTORY");
                            realNodeId = node.getProperty("jcr:versionableUuid").getString();
                            try {
                                node = systemSession.getNodeByUUID(realNodeId).getParent();
                                log.debug(this.subject.getPrincipals() + " Real -> " + node.getPath());
                            }
                            catch (ItemNotFoundException e) {
                                log.debug(this.subject.getPrincipals() + " **************");
                                log.debug(this.subject.getPrincipals() + " **************");
                                log.debug(this.subject.getPrincipals() + " -> " + e.getMessage());
                            }
                        }
                        HashSet<String> sUsersRead = new HashSet<String>();
                        Value[] vUsersRead = node.getProperty("okm:authUsersRead").getValues();
                        for (int i = 0; i < vUsersRead.length; ++i) {
                            sUsersRead.add(vUsersRead[i].getString());
                        }
                        HashSet<String> sRolesRead = new HashSet<String>();
                        Value[] vRolesRead = node.getProperty("okm:authRolesRead").getValues();
                        for (int i = 0; i < vRolesRead.length; ++i) {
                            sRolesRead.add(vRolesRead[i].getString());
                        }
                        HashSet<String> sUsersWrite = new HashSet<String>();
                        Value[] vUsersWrite = node.getProperty("okm:authUsersWrite").getValues();
                        for (int i = 0; i < vUsersWrite.length; ++i) {
                            sUsersWrite.add(vUsersWrite[i].getString());
                        }
                        HashSet<String> sRolesWrite = new HashSet<String>();
                        Value[] vRolesWrite = node.getProperty("okm:authRolesWrite").getValues();
                        for (int i = 0; i < vRolesWrite.length; ++i) {
                            sRolesWrite.add(vRolesWrite[i].getString());
                        }
                        HashSet<String> sUsersDelete = new HashSet<String>();
                        Value[] vUsersDelete = node.getProperty("okm:authUsersDelete").getValues();
                        for (int i = 0; i < vUsersDelete.length; ++i) {
                            sUsersDelete.add(vUsersDelete[i].getString());
                        }
                        HashSet<String> sRolesDelete = new HashSet<String>();
                        Value[] vRolesDelete = node.getProperty("okm:authRolesDelete").getValues();
                        for (int i = 0; i < vRolesDelete.length; ++i) {
                            sRolesDelete.add(vRolesDelete[i].getString());
                        }
                        HashSet<String> sUsersSecurity = new HashSet<String>();
                        Value[] vUsersSecurity = node.getProperty("okm:authUsersSecurity").getValues();
                        for (int i = 0; i < vUsersSecurity.length; ++i) {
                            sUsersSecurity.add(vUsersSecurity[i].getString());
                        }
                        HashSet<String> sRolesSecurity = new HashSet<String>();
                        Value[] vRolesSecurity = node.getProperty("okm:authRolesSecurity").getValues();
                        for (int i = 0; i < vRolesSecurity.length; ++i) {
                            sRolesSecurity.add(vRolesSecurity[i].getString());
                        }
                        nPerms = new NodePermissions();
                        nPerms.setUsersRead(sUsersRead);
                        nPerms.setRolesRead(sRolesRead);
                        nPerms.setUsersWrite(sUsersWrite);
                        nPerms.setRolesWrite(sRolesWrite);
                        nPerms.setUsersDelete(sUsersDelete);
                        nPerms.setRolesDelete(sRolesDelete);
                        nPerms.setUsersSecurity(sUsersSecurity);
                        nPerms.setRolesSecurity(sRolesSecurity);
                        NodePermissionsManager.put(nodeId, nPerms);
                    }
                }
                if (permissions == 1) {
                    access = this.checkRead(nPerms.getUsersRead(), nPerms.getRolesRead());
                } else if (permissions == 2 || permissions == 4) {
                    access = this.checkWrite(nPerms.getUsersWrite(), nPerms.getRolesWrite());
                }
            }
        }
        try {
            log.debug(this.subject.getPrincipals() + " Path: " + this.hierMgr.getPath(id));
        }
        catch (ItemNotFoundException e) {
            log.debug(this.subject.getPrincipals() + " hierMgr.getPath() > ItemNotFoundException: " + e.getMessage());
        }
        log.debug(this.subject.getPrincipals() + " isGranted " + (permissions == 1 ? "READ" : (permissions == 2 ? "WRITE" : (permissions == 4 ? "REMOVE" : "NONE"))) + ": " + access);
        log.debug("-------------------------------------");
        return access;
    }

    public boolean canAccess(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        boolean access = true;
        log.debug("canAccess(" + workspaceName + ")");
        log.debug("canAccess: " + access);
        return access;
    }

    private boolean checkRead(Set<String> usersRead, Set<String> rolesRead) {
        log.debug("checkRead(" + usersRead + ", " + rolesRead + ")");
        boolean access = false;
        if (usersRead.contains(this.principalUser)) {
            access = true;
        } else {
            Iterator<String> it = this.principalRoles.iterator();
            while (it.hasNext()) {
                if (!rolesRead.contains(it.next())) continue;
                access = true;
                break;
            }
        }
        log.debug("checkRead: " + access);
        return access;
    }

    private boolean checkWrite(Set<String> usersWrite, Set<String> rolesWrite) {
        log.debug("checkWrite(" + usersWrite + ", " + rolesWrite + ")");
        boolean access = false;
        if (usersWrite.contains(this.principalUser)) {
            access = true;
        } else {
            Iterator<String> it = this.principalRoles.iterator();
            while (it.hasNext()) {
                if (!rolesWrite.contains(it.next())) continue;
                access = true;
                break;
            }
        }
        log.debug("checkWrite: " + access);
        return access;
    }

    public boolean canRead(Path arg0) throws RepositoryException {
        return false;
    }

    public void init(AMContext arg0, AccessControlProvider arg1, WorkspaceAccessManager arg2) throws AccessDeniedException, Exception {
    }

    public boolean isGranted(Path arg0, int arg1) throws RepositoryException {
        return false;
    }

    public boolean isGranted(Path arg0, Name arg1, int arg2) throws RepositoryException {
        return false;
    }

    public void checkPermission(Path arg0, int arg1) throws AccessDeniedException, RepositoryException {
    }
}

