/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.cache;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.UserDocumentKeywordsDAO;
import com.openkm.dao.bean.cache.UserDocumentKeywords;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDocumentKeywordsManager {
    private static Logger log = LoggerFactory.getLogger(UserDocumentKeywordsManager.class);
    private static Map<String, Map<String, UserDocumentKeywords>> userDocumentKeywordsMgr = new HashMap<String, Map<String, UserDocumentKeywords>>();

    public static Map<String, UserDocumentKeywords> get(String uid) {
        Map<String, UserDocumentKeywords> userDocKeywords = userDocumentKeywordsMgr.get(uid);
        if (userDocKeywords == null) {
            userDocKeywords = new HashMap<String, UserDocumentKeywords>();
        }
        return userDocKeywords;
    }

    public static synchronized void add(String user, String nodePath, String keyword) {
        log.info("add({}, {}, {})", new Object[]{user, nodePath, keyword});
        Map<String, UserDocumentKeywords> usrDocs = UserDocumentKeywordsManager.get(user);
        UserDocumentKeywords udk = usrDocs.get(nodePath);
        if (udk == null) {
            udk = new UserDocumentKeywords();
            udk.setUser(user);
            udk.setDocument(nodePath);
            usrDocs.put(nodePath, udk);
            userDocumentKeywordsMgr.put(user, usrDocs);
        }
        udk.getKeywords().add(keyword);
    }

    public static synchronized void remove(String user, String nodePath, String keyword) {
        Map<String, UserDocumentKeywords> usrDocs = UserDocumentKeywordsManager.get(user);
        UserDocumentKeywords udk = usrDocs.get(nodePath);
        if (udk == null) {
            udk = new UserDocumentKeywords();
            udk.setUser(user);
            udk.setDocument(nodePath);
            usrDocs.put(nodePath, udk);
            userDocumentKeywordsMgr.put(user, usrDocs);
        }
        udk.getKeywords().remove(keyword);
        if (udk.getKeywords().isEmpty()) {
            usrDocs.remove(nodePath);
        }
    }

    public static synchronized void refreshUserDocKeywords(Session session) throws RepositoryException {
        log.info("refreshUserDocKeywords({})", (Object)session);
        String statement = "/jcr:root/okm:root/element(*,okm:document)";
        try {
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            Query query = queryManager.createQuery(statement, "xpath");
            QueryResult qResult = query.execute();
            HashMap userDocKeywords = new HashMap();
            NodeIterator nit = qResult.getNodes();
            while (nit.hasNext()) {
                Node docNode = nit.nextNode();
                Value[] keywords = docNode.getProperty("okm:keywords").getValues();
                HashSet<String> keywordSet = new HashSet<String>();
                for (int i = 0; i < keywords.length; ++i) {
                    keywordSet.add(keywords[i].getString());
                }
                userDocKeywords.put(docNode.getUUID(), keywordSet);
            }
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        log.info("refreshUserDocKeywords: void");
    }

    public static synchronized void serialize() throws DatabaseException {
        UserDocumentKeywordsDAO.clean();
        for (String user : userDocumentKeywordsMgr.keySet()) {
            log.info("User: {}", (Object)user);
            for (UserDocumentKeywords udk : userDocumentKeywordsMgr.get(user).values()) {
                log.info("Document: {}", (Object)udk);
                UserDocumentKeywordsDAO.create(udk);
            }
        }
    }

    public static synchronized void deserialize() throws DatabaseException {
        for (String user : UserDocumentKeywordsDAO.findUsers()) {
            HashMap<String, UserDocumentKeywords> udkMap = new HashMap<String, UserDocumentKeywords>();
            for (UserDocumentKeywords udk : UserDocumentKeywordsDAO.findByUser(user)) {
                udkMap.put(udk.getDocument(), udk);
            }
            userDocumentKeywordsMgr.put(user, udkMap);
        }
    }
}

