/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.cache;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.UserItemsDAO;
import com.openkm.dao.bean.cache.UserItems;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserItemsManager {
    private static Logger log = LoggerFactory.getLogger(UserItemsManager.class);
    private static Map<String, UserItems> userItemsMgr = new HashMap<String, UserItems>();

    public static UserItems get(String uid) {
        UserItems userItems = userItemsMgr.get(uid);
        if (userItems == null) {
            userItems = new UserItems();
            userItems.setUser(uid);
            userItemsMgr.put(uid, userItems);
        }
        return userItems;
    }

    public static synchronized void incDocuments(String uid, int value) {
        log.debug("incDocuments({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setDocuments(userItems.getDocuments() + value);
    }

    public static synchronized void decDocuments(String uid, int value) {
        log.debug("decDocuments({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setDocuments(userItems.getDocuments() - value);
    }

    public static synchronized void incFolders(String uid, int value) {
        log.debug("incFolders({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setFolders(userItems.getFolders() + value);
    }

    public static synchronized void decFolders(String uid, int value) {
        log.debug("decFolders({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setFolders(userItems.getFolders() - value);
    }

    public static synchronized void incSize(String uid, long value) {
        log.debug("incSize({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setSize(userItems.getSize() + value);
    }

    public static synchronized void decSize(String uid, long value) {
        log.debug("decSize({}, {})", (Object)uid, (Object)value);
        UserItems userItems = UserItemsManager.get(uid);
        userItems.setSize(userItems.getSize() - value);
    }

    public static synchronized void refreshUserItems(Session session) throws RepositoryException {
        log.info("refreshUserItems({})", (Object)session);
        try {
            String statement = "/jcr:root/okm:root//element(*, okm:document)[okm:content/@okm:author='" + session.getUserID() + "']";
            Workspace workspace = session.getWorkspace();
            QueryManager queryManager = workspace.getQueryManager();
            Query query = queryManager.createQuery(statement, "xpath");
            QueryResult result = query.execute();
            long size = 0L;
            NodeIterator nit = result.getNodes();
            while (nit.hasNext()) {
                Node node = nit.nextNode();
                Node contentNode = node.getNode("okm:content");
                size += contentNode.getProperty("okm:size").getLong();
            }
            UserItems userItems = new UserItems();
            userItemsMgr.put(session.getUserID(), userItems);
        }
        catch (javax.jcr.RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RepositoryException(e.getMessage(), e);
        }
        log.info("refreshUserItems: void");
    }

    public static synchronized void serialize() throws DatabaseException {
        for (String user : userItemsMgr.keySet()) {
            UserItemsDAO.update(userItemsMgr.get(user));
        }
    }

    public static synchronized void deserialize() throws DatabaseException {
        for (UserItems ui : UserItemsDAO.findAll()) {
            userItemsMgr.put(ui.getUser(), ui);
        }
    }
}

