/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.frontend.client.OKMException;
import com.openkm.frontend.client.contants.service.ErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ChatManager {
    private static final int ACTION_LOGIN = 0;
    private static final int ACTION_LOGOUT = 1;
    private static final int ACTION_ADD_ROOM_TO_USER = 2;
    private static final int ACTION_REMOVE_USER_ROOM = 3;
    private static final int ACTION_ADD_PENDING_ROOM_TO_USER = 4;
    private static final int ACTION_GET_PENDING_USER_FROM_ROOM = 5;
    private static final int ACTION_GET_PENDING_USER_ROOM_MESSAGE = 6;
    private static final int ACTION_ADD_USER_MESSAGE_TO_ROOM = 7;
    private static final int ACTION_CREATE_MESSAGE_ROOM = 8;
    private static final int ACTION_CREATE_MESSAGE_USER_ROOM = 9;
    private static final int ACTION_REMOVE_USER_MESSAGE_ROOM = 10;
    private static final int ACTION_DELETE_EMPTY_MESSAGE_ROOM = 11;
    private static final int ACTION_GET_USERS_IN_MESSAGE_ROOM = 12;
    private static List<String> loggedUsers = new ArrayList<String>();
    private static Map<String, List<String>> usersRooms = new HashMap<String, List<String>>();
    private static Map<String, List<String>> pendingUsersRooms = new HashMap<String, List<String>>();
    private static Map<String, HashMap<String, List<String>>> msgUsersRooms = new HashMap<String, HashMap<String, List<String>>>();

    public void login(String user) throws OKMException {
        this.usersLoggedAction(user, 0);
    }

    public void logout(String user) throws OKMException {
        this.usersLoggedAction(user, 1);
    }

    public List<String> getLoggedUsers() {
        return loggedUsers;
    }

    public String createNewChatRoom(String fromUser, String toUser) {
        String room = UUID.randomUUID().toString();
        this.usersRoomAction(room, toUser, 2);
        this.pendingRoomAction(room, toUser, 4);
        this.usersRoomAction(room, fromUser, 2);
        this.messageUserRoomAction(room, "", "", 8);
        this.messageUserRoomAction(room, toUser, "", 9);
        this.messageUserRoomAction(room, fromUser, "", 9);
        return room;
    }

    public List<String> getPendingMessage(String user, String room) {
        return this.messageUserRoomAction(room, user, "", 6);
    }

    public List<String> getPendingChatRoomUser(String user) {
        return this.pendingRoomAction("", user, 5);
    }

    public void addMessageToRoom(String user, String room, String msg) {
        this.messageUserRoomAction(room, user, msg, 7);
    }

    public void closeRoom(String user, String room) {
        this.usersRoomAction(room, user, 3);
        this.messageUserRoomAction(room, user, "", 10);
        this.messageUserRoomAction(room, "", "", 11);
    }

    public void addUserToChatRoom(String user, String room) {
        this.usersRoomAction(room, user, 2);
        this.pendingRoomAction(room, user, 4);
        this.messageUserRoomAction(room, user, "", 9);
    }

    public int getNumberOfUsersInRoom(String room) {
        return this.messageUserRoomAction(room, "", "", 12).size();
    }

    public List<String> getUsersInRoom(String room) {
        return this.messageUserRoomAction(room, "", "", 12);
    }

    private synchronized void usersLoggedAction(String user, int action) throws OKMException {
        switch (action) {
            case 0: {
                if (loggedUsers.contains(user)) {
                    throw new OKMException(ErrorCode.get("034", "045"), "User yet logged");
                }
                loggedUsers.add(user);
                Collections.sort(loggedUsers);
                break;
            }
            case 1: {
                if (loggedUsers.contains(user)) {
                    loggedUsers.remove(user);
                }
                if (pendingUsersRooms.containsKey(user)) {
                    pendingUsersRooms.remove(user);
                }
                if (!usersRooms.containsKey(user)) break;
                List<String> rooms = usersRooms.get(user);
                for (String room : rooms) {
                    Map roomMessages;
                    if (!msgUsersRooms.containsKey(room) || !(roomMessages = (Map)msgUsersRooms.get(room)).containsKey(user)) continue;
                    roomMessages.remove(user);
                }
                break;
            }
        }
    }

    private synchronized void usersRoomAction(String room, String user, int action) {
        switch (action) {
            case 2: {
                if (!usersRooms.keySet().contains(user)) {
                    ArrayList<String> userRoomList = new ArrayList<String>();
                    userRoomList.add(room);
                    usersRooms.put(user, userRoomList);
                    break;
                }
                List<String> userRoomList = usersRooms.get(user);
                if (userRoomList.contains(room)) break;
                userRoomList.add(room);
                break;
            }
            case 3: {
                List<String> userRoomList;
                if (!usersRooms.keySet().contains(user) || !(userRoomList = usersRooms.get(user)).contains(room)) break;
                userRoomList.remove(room);
            }
        }
    }

    private synchronized List<String> pendingRoomAction(String room, String user, int action) {
        switch (action) {
            case 4: {
                if (!pendingUsersRooms.keySet().contains(user)) {
                    ArrayList<String> userPendingRoomList = new ArrayList<String>();
                    userPendingRoomList.add(room);
                    pendingUsersRooms.put(user, userPendingRoomList);
                } else {
                    List<String> userPendingRoomList = pendingUsersRooms.get(user);
                    if (!userPendingRoomList.contains(room)) {
                        userPendingRoomList.add(room);
                    }
                }
                return new ArrayList<String>();
            }
            case 5: {
                if (pendingUsersRooms.keySet().contains(user)) {
                    List<String> userRooms = pendingUsersRooms.get(user);
                    pendingUsersRooms.remove(user);
                    return userRooms;
                }
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    private synchronized List<String> messageUserRoomAction(String room, String user, String msg, int action) {
        switch (action) {
            case 6: {
                if (msgUsersRooms.containsKey(room) && msgUsersRooms.get(room).containsKey(user)) {
                    List<String> messages = msgUsersRooms.get(room).get(user);
                    msgUsersRooms.get(room).put(user, new ArrayList());
                    return messages;
                }
                return new ArrayList<String>();
            }
            case 7: {
                String message = "<b>" + user + "</b>: " + msg;
                if (msgUsersRooms.containsKey(room)) {
                    Map roomMap = msgUsersRooms.get(room);
                    for (String roomUser : roomMap.keySet()) {
                        if (roomUser.equals(user)) continue;
                        ((List)roomMap.get(roomUser)).add(message);
                    }
                }
                return new ArrayList<String>();
            }
            case 8: {
                if (!msgUsersRooms.containsKey(room)) {
                    msgUsersRooms.put(room, new HashMap());
                }
                return new ArrayList<String>();
            }
            case 9: {
                if (msgUsersRooms.containsKey(room) && !msgUsersRooms.get(room).containsKey(user)) {
                    msgUsersRooms.get(room).put(user, new ArrayList());
                }
                return new ArrayList<String>();
            }
            case 10: {
                if (msgUsersRooms.containsKey(room) && msgUsersRooms.get(room).containsKey(user)) {
                    msgUsersRooms.get(room).remove(user);
                }
                return new ArrayList<String>();
            }
            case 11: {
                if (msgUsersRooms.containsKey(room) && msgUsersRooms.get(room).keySet().size() == 0) {
                    msgUsersRooms.remove(room);
                }
                return new ArrayList<String>();
            }
            case 12: {
                if (msgUsersRooms.containsKey(room)) {
                    Set<String> userList = msgUsersRooms.get(room).keySet();
                    return new ArrayList<String>(userList);
                }
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }
}

