/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import bsh.EvalError;
import com.kenai.crontabparser.CronTabExpression;
import com.openkm.core.DatabaseException;
import com.openkm.dao.CronTabDAO;
import com.openkm.dao.bean.CronTab;
import com.openkm.util.ExecutionUtils;
import com.openkm.util.MailUtils;
import com.openkm.util.SecureStore;
import java.text.ParseException;
import java.util.Calendar;
import java.util.TimerTask;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cron
extends TimerTask {
    private static Logger log = LoggerFactory.getLogger(Cron.class);
    public static final String CRON_TASK = "cronTask";

    @Override
    public void run() {
        log.debug("*** Cron activated ***");
        Calendar cal = Calendar.getInstance();
        try {
            for (CronTab ct : CronTabDAO.findAll()) {
                if (!ct.isActive()) continue;
                try {
                    Runnable runner;
                    CronTabExpression cte = CronTabExpression.parse((String)ct.getExpression());
                    if (!cte.matches(cal)) continue;
                    log.info("Id: {}, Name: {}, Mime: {}", new Object[]{ct.getId(), ct.getName(), ct.getFileMime()});
                    if ("application/x-bsh".equals(ct.getFileMime())) {
                        runner = new RunnerBsh(ct.getId(), ct.getName(), ct.getMail(), new String(SecureStore.b64Decode(ct.getFileContent())));
                        new Thread(runner).start();
                        continue;
                    }
                    if (!"application/x-java-archive".equals(ct.getFileMime())) continue;
                    runner = new RunnerJar(ct.getId(), ct.getName(), ct.getMail(), SecureStore.b64Decode(ct.getFileContent()));
                    new Thread(runner).start();
                }
                catch (ParseException e) {
                    log.warn(e.getMessage() + " : " + ct.getExpression());
                }
            }
        }
        catch (DatabaseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static class RunnerJar
    implements Runnable {
        private byte[] content;
        private String name;
        private String mail;
        private int ctId;

        public RunnerJar(int ctId, String name, String mail, byte[] content) {
            this.content = content;
            this.name = name;
            this.mail = mail;
            this.ctId = ctId;
        }

        @Override
        public void run() {
            if (this.content != null) {
                block14: {
                    try {
                        CronTabDAO.setLastBegin(this.ctId);
                    }
                    catch (DatabaseException e) {
                        log.warn("Error setting last begin in crontab {}: {}", (Object)this.ctId, (Object)e.getMessage());
                    }
                    try {
                        Object ret = ExecutionUtils.getInstance().runJar(this.content, Cron.CRON_TASK);
                        try {
                            String msg;
                            String string = msg = ret == null ? "" : ret.toString();
                            if (!this.mail.equals("")) {
                                MailUtils.sendMessage(this.mail, "Cron task '" + this.name + "' executed - Ok", msg);
                                break block14;
                            }
                            log.warn("Crontab task email is empty: {}", (Object)msg);
                        }
                        catch (MessagingException e) {
                            log.warn("Error sending mail: {}", (Object)e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        try {
                            String msg = e.toString();
                            if (this.mail.equals("")) {
                                log.info(msg);
                            } else {
                                MailUtils.sendMessage(this.mail, "Cron task '" + this.name + "' executed - Error", msg);
                            }
                        }
                        catch (MessagingException e1) {
                            log.warn("Error sending mail: {}", (Object)e.getMessage());
                        }
                    }
                }
                try {
                    CronTabDAO.setLastEnd(this.ctId);
                }
                catch (DatabaseException e) {
                    log.warn("Error setting last end in crontab {}: {}", (Object)this.ctId, (Object)e.getMessage());
                }
            }
        }
    }

    public static class RunnerBsh
    implements Runnable {
        private String script;
        private String name;
        private String mail;
        private int ctId;

        public RunnerBsh(int ctId, String name, String mail, String script) {
            this.script = script;
            this.name = name;
            this.mail = mail;
            this.ctId = ctId;
        }

        @Override
        public void run() {
            if (this.script != null) {
                block14: {
                    try {
                        CronTabDAO.setLastBegin(this.ctId);
                    }
                    catch (DatabaseException e) {
                        log.warn("Error setting last begin in crontab {}: {}", (Object)this.ctId, (Object)e.getMessage());
                    }
                    try {
                        Object[] ret = ExecutionUtils.runScript(this.script);
                        try {
                            StringBuilder msg = new StringBuilder();
                            msg.append("Return: ").append(ret[0]);
                            msg.append("\n<hr/>\n");
                            msg.append("StdOut: ").append(ret[1]);
                            msg.append("\n<hr/>\n");
                            msg.append("StdErr: ").append(ret[2]);
                            if (!this.mail.equals("")) {
                                MailUtils.sendMessage(this.mail, "Cron task '" + this.name + "' executed - Ok", msg.toString());
                                break block14;
                            }
                            log.warn("Crontab task email is empty: {}", (Object)msg);
                        }
                        catch (MessagingException e) {
                            log.warn("Error sending mail: {}", (Object)e.getMessage());
                        }
                    }
                    catch (EvalError e) {
                        try {
                            String msg = e.toString();
                            if (this.mail.equals("")) {
                                log.info(msg);
                            } else {
                                MailUtils.sendMessage(this.mail, "Cron task '" + this.name + "' executed - Error", msg);
                            }
                        }
                        catch (MessagingException e1) {
                            log.warn("Error sending mail: {}", (Object)e.getMessage());
                        }
                    }
                }
                try {
                    CronTabDAO.setLastEnd(this.ctId);
                }
                catch (DatabaseException e) {
                    log.warn("Error setting last end in crontab {}: {}", (Object)this.ctId, (Object)e.getMessage());
                }
            }
        }
    }
}

