/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.core.OKMSystemSession;
import com.openkm.module.direct.DirectRepositoryModule;
import java.io.IOException;
import java.util.Iterator;
import java.util.TimerTask;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.data.GarbageCollector;
import org.apache.jackrabbit.core.data.ScanEventListener;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreGarbageCollector
extends TimerTask
implements ScanEventListener {
    private static Logger log = LoggerFactory.getLogger(DataStoreGarbageCollector.class);
    private static volatile boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (running) {
            log.warn("*** Datastore garbage collector already running ***");
        } else {
            running = true;
            log.info("*** Begin datastore garbage collector ***");
            GarbageCollector gc = null;
            OKMSystemSession tmp = null;
            try {
                Repository rep = DirectRepositoryModule.getRepository();
                RepositoryConfig rc = ((RepositoryImpl)rep).getConfig();
                String name = rc.getDefaultWorkspaceName();
                WorkspaceConfig wc = rc.getWorkspaceConfig(name);
                tmp = OKMSystemSession.create((RepositoryImpl)rep, wc);
                for (int i = 0; i < 5; ++i) {
                    System.gc();
                }
                gc = ((SessionImpl)tmp).createDataStoreGarbageCollector();
                gc.setScanEventListener((ScanEventListener)this);
                gc.scan();
                Iterator it = gc.getDataStore().getAllIdentifiers();
                while (it.hasNext()) {
                    log.info("DataIdent: {}", it.next());
                }
                gc.stopScan();
                int deleted = gc.deleteUnused();
                log.info("Deleted garbage documents: {}", (Object)deleted);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalStateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (ItemStateException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                log.info("Clean temporal session and close DSGC");
                try {
                    if (gc != null) {
                        gc.close();
                    }
                    if (tmp != null) {
                        tmp.logout();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                running = false;
            }
        }
        log.info("*** End datastore garbage collector ***");
    }

    public void afterScanning(Node node) throws RepositoryException {
    }

    public void beforeScanning(Node node) throws RepositoryException {
    }

    public void done() {
        log.info("ScanEventListener: done");
    }
}

