/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.bean.HttpSessionInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class HttpSessionManager {
    private static Logger log = LoggerFactory.getLogger(HttpSessionManager.class);
    private static HttpSessionManager instance = new HttpSessionManager();
    private List<HttpSessionInfo> sessions = new ArrayList<HttpSessionInfo>();

    private HttpSessionManager() {
    }

    public static HttpSessionManager getInstance() {
        return instance;
    }

    public synchronized void add(HttpServletRequest request) {
        HttpSessionInfo si = new HttpSessionInfo();
        HttpSession s = request.getSession();
        boolean add = true;
        for (HttpSessionInfo rsi : this.sessions) {
            if (!rsi.getId().equals(s.getId())) continue;
            add = false;
        }
        if (add) {
            si.setUser(request.getRemoteUser());
            si.setIp(request.getRemoteAddr());
            try {
                InetAddress addr = Address.getByAddress((String)request.getRemoteAddr());
                String hostName = Address.getHostName((InetAddress)addr);
                if (hostName.endsWith(".")) {
                    si.setHost(hostName.substring(0, hostName.length() - 1));
                } else {
                    si.setHost(hostName);
                }
            }
            catch (UnknownHostException e) {
                si.setHost(request.getRemoteHost());
            }
            si.setId(s.getId());
            Calendar creation = Calendar.getInstance();
            creation.setTimeInMillis(s.getCreationTime());
            si.setCreation(creation);
            Calendar lastAccess = Calendar.getInstance();
            lastAccess.setTimeInMillis(s.getLastAccessedTime());
            si.setLastAccess(lastAccess);
            s.setAttribute("user", (Object)request.getRemoteUser());
            this.sessions.add(si);
        }
    }

    public synchronized void update(String id) {
        for (HttpSessionInfo si : this.sessions) {
            if (!si.getId().equals(id)) continue;
            si.setLastAccess(Calendar.getInstance());
        }
    }

    public synchronized void remove(String id) {
        Iterator<HttpSessionInfo> it = this.sessions.iterator();
        while (it.hasNext()) {
            HttpSessionInfo si = it.next();
            if (!si.getId().equals(id)) continue;
            it.remove();
            break;
        }
    }

    public HttpSessionInfo getSession(String id) {
        for (HttpSessionInfo si : this.sessions) {
            if (!si.getId().equals(id)) continue;
            return si;
        }
        return null;
    }

    public List<HttpSessionInfo> getSessions() {
        return this.sessions;
    }
}

