/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.bean.JcrSessionInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrSessionManager {
    private static Logger log = LoggerFactory.getLogger(JcrSessionManager.class);
    private static JcrSessionManager instance = new JcrSessionManager();
    private Map<String, JcrSessionInfo> sessions = new HashMap<String, JcrSessionInfo>();
    private static String systemToken;

    private JcrSessionManager() {
    }

    public static JcrSessionManager getInstance() {
        return instance;
    }

    public String getSystemToken() {
        return systemToken;
    }

    public void putSystemSession(Session session) {
        systemToken = UUID.randomUUID().toString();
        this.add(systemToken, session);
    }

    public Session getSystemSession() {
        return this.get(this.getSystemToken());
    }

    public synchronized void add(String token, Session session) {
        JcrSessionInfo si = new JcrSessionInfo();
        si.setSession(session);
        si.setCreation(Calendar.getInstance());
        si.setLastAccess(Calendar.getInstance());
        this.sessions.put(token, si);
    }

    public Session get(String token) {
        JcrSessionInfo si = this.sessions.get(token);
        if (si != null) {
            si.setLastAccess(Calendar.getInstance());
            return si.getSession();
        }
        return null;
    }

    public JcrSessionInfo getInfo(String token) {
        return this.sessions.get(token);
    }

    public synchronized void remove(String token) {
        this.sessions.remove(token);
    }

    public List<String> getTokens() {
        ArrayList<String> list = new ArrayList<String>();
        for (String token : this.sessions.keySet()) {
            if (systemToken.equals(token)) continue;
            list.add(token);
        }
        return list;
    }

    public Map<String, JcrSessionInfo> getSessions() {
        return this.sessions;
    }
}

