/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.dao.LanguageDAO;
import com.openkm.dao.bean.Language;
import com.openkm.dao.bean.Translation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspI18nBundle {
    private static Logger log;
    private static Map<String, Map<String, String>> translations;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String langId, String key) {
        Object object = lock;
        synchronized (object) {
            log.debug("call translate (lang={}, key={})", new Object[]{langId, key});
            Map<String, String> tr = translations.get(langId);
            if (tr != null) {
                String ret = tr.get(key);
                if (ret != null) {
                    log.debug("translate (lang={}, key={}) => OK: {}", new Object[]{langId, key, ret});
                    return ret;
                }
                log.debug("translate (lang={}, key={}) => no such key", new Object[]{langId, key});
            } else {
                log.debug("translate (lang={}, key={}) => no such lang", new Object[]{langId, key});
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readLanguages() {
        Object object = lock;
        synchronized (object) {
            List<Language> langs;
            translations = new HashMap<String, Map<String, String>>();
            try {
                langs = LanguageDAO.findAll();
            }
            catch (Exception e) {
                log.error("Unable to read languages list from DB", (Throwable)e);
                return;
            }
            for (Language language : langs) {
                try {
                    HashMap<String, String> tr = new HashMap<String, String>();
                    for (Translation translation : language.getTranslations()) {
                        String key = translation.getTranslationId().getModule() + "." + translation.getTranslationId().getKey();
                        tr.put(key, translation.getText());
                    }
                    translations.put(language.getId(), tr);
                }
                catch (Exception e) {
                    log.error(String.format("Unable to read %1$s language", language.getId()), (Throwable)e);
                }
            }
        }
    }

    static {
        lock = new Object();
        JspI18nBundle.readLanguages();
        log = LoggerFactory.getLogger(JspI18nBundle.class);
    }
}

