/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.core.JspI18nBundle;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JspTranslation {
    private static Logger log = LoggerFactory.getLogger(JspTranslation.class);
    private String locale = "en-GB";

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setRequest(HttpServletRequest request, HttpSession session) {
        String lang = (String)request.getSession().getAttribute("lang");
        if (lang != null) {
            this.setLocale(lang);
            log.debug("JSP translation: locale set from session ({})", new Object[]{this.getLocale()});
        } else {
            lang = (String)request.getAttribute("lang");
            if (lang != null) {
                this.setLocale(lang);
                log.debug("JSP translation: locale set from URL parameter ({})", new Object[]{this.getLocale()});
            } else {
                Cookie[] cookies = request.getCookies();
                boolean found = false;
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if (cookie == null || !"lang".equals(cookie.getName())) continue;
                        this.setLocale(cookie.getValue());
                        log.debug("JSP translation: locale set from cookie ({})", new Object[]{this.getLocale()});
                        found = true;
                    }
                }
                if (!found) {
                    log.debug("JSP translation: no locale set");
                }
            }
        }
    }

    public String translate(String key) {
        return JspI18nBundle.translate(this.locale, key);
    }
}

