/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.core.Config;
import com.openkm.module.direct.DirectRepositoryModule;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMAccessManager
implements AccessManager {
    private static Logger log = LoggerFactory.getLogger(OKMAccessManager.class);
    private AMContext context;
    private Subject subject = null;
    private String principalUser = null;
    private Set<String> principalRoles = null;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        log.debug("init({})", (Object)context);
        this.context = context;
        this.subject = context.getSubject();
        this.principalRoles = new HashSet<String>();
        for (Principal obj : this.subject.getPrincipals()) {
            log.debug("##### {}", obj.getClass());
            if (obj instanceof EveryonePrincipal) {
                log.debug("o.a.j.c.s.p.EveryonePrincipal: {}", (Object)obj);
                EveryonePrincipal everyonePrincipal = (EveryonePrincipal)obj;
                continue;
            }
            if (obj instanceof UserPrincipal) {
                log.debug("o.a.j.c.s.UserPrincipal: {}", (Object)obj);
                UserPrincipal userPrincipal = (UserPrincipal)obj;
                this.principalUser = userPrincipal.getName();
                this.principalRoles.add(Config.DEFAULT_USER_ROLE);
                continue;
            }
            if (obj instanceof Group) {
                log.debug("j.s.a.Group: {}", (Object)obj);
                Group group = (Group)obj;
                Enumeration groups = group.members();
                while (groups.hasMoreElements()) {
                    Principal rol = (Principal)groups.nextElement();
                    log.debug("Rol: {}", (Object)rol.getName());
                    this.principalRoles.add(rol.getName());
                }
                continue;
            }
            if (!(obj instanceof Principal)) continue;
            log.debug("j.s.Principal: {}", (Object)obj);
            Principal principal = obj;
            this.principalUser = principal.getName();
        }
        log.debug("PrincipalRoles: {}", this.principalRoles);
        log.debug("init: void");
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessMgr) throws AccessDeniedException, Exception {
        log.debug("init({}, {}, {}", new Object[]{context, acProvider, wspAccessMgr});
        this.init(context);
    }

    public void close() throws Exception {
        log.debug("close()");
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        return true;
    }

    public boolean canRead(Path itemPath) throws RepositoryException {
        return true;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
    }

    public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
    }

    public boolean isGranted(ItemId id, int permissions) throws ItemNotFoundException, RepositoryException {
        log.debug("deprecated - isGranted({}, {} => {})", new Object[]{id, permissions, this.permissionsToString(this.deprecatedPermissionsToNewApi(permissions))});
        Path path = this.context.getHierarchyManager().getPath(id);
        boolean access = this.isGranted(path, this.deprecatedPermissionsToNewApi(permissions));
        log.debug("deprecated - isGranted: {}", (Object)access);
        return access;
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        return true;
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        log.debug("isGranted({}, {} => {})", new Object[]{absPath, permissions, this.permissionsToString(permissions)});
        boolean access = this.checkAccess(absPath, permissions);
        log.debug("isGranted: {}", (Object)access);
        return access;
    }

    private boolean checkAccess(Path absPath, int permissions) throws RepositoryException {
        log.debug("checkAccess({}, {} => {})", new Object[]{absPath, permissions, this.permissionsToString(permissions)});
        Session systemSession = DirectRepositoryModule.getSystemSession();
        boolean access = false;
        if (this.principalRoles.contains(Config.DEFAULT_ADMIN_ROLE)) {
            access = true;
        } else {
            log.debug("{} Path: {}", this.subject.getPrincipals(), (Object)absPath);
            NodeId nodeId = this.context.getHierarchyManager().resolveNodePath(absPath);
            if (nodeId != null) {
                log.debug("{} This is a NODE", this.subject.getPrincipals());
            } else {
                PropertyId propertyId = this.context.getHierarchyManager().resolvePropertyPath(absPath);
                if (propertyId != null) {
                    log.debug("{} This is a PROPERTY", this.subject.getPrincipals());
                    nodeId = propertyId.getParentId();
                } else {
                    log.debug("{} This is a UNKNOWN: {}", this.subject.getPrincipals(), (Object)absPath);
                    Path ancestor = absPath.getAncestor(1);
                    log.debug("UNKNOWN ancestor: {}", (Object)ancestor);
                    nodeId = this.context.getHierarchyManager().resolveNodePath(ancestor);
                }
            }
            if (access || absPath.denotesRoot() || nodeId == null) {
                access = true;
            } else {
                NodeImpl node = null;
                try {
                    node = ((SessionImpl)systemSession).getNodeById(nodeId);
                }
                catch (ItemNotFoundException e) {
                    if ((permissions & 4) != 0) {
                        nodeId = this.context.getHierarchyManager().resolveNodePath(absPath.getAncestor(1));
                        try {
                            node = ((SessionImpl)systemSession).getNodeById(nodeId);
                        }
                        catch (ItemNotFoundException e2) {
                            access = true;
                        }
                    }
                    access = true;
                }
                if (node == null) {
                    access = true;
                } else {
                    String realNodeId;
                    log.debug("{} Node Name: {}", this.subject.getPrincipals(), (Object)node.getPath());
                    log.debug("{} Node Type: {}", this.subject.getPrincipals(), (Object)node.getPrimaryNodeType().getName());
                    if (node.isNodeType("okm:resource")) {
                        log.debug("{} Node is CONTENT_TYPE", this.subject.getPrincipals());
                        node = node.getParent();
                        log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                    } else if (node.isNodeType("okm:notes")) {
                        log.debug("{} Node is NOTE_LIST_TYPE", this.subject.getPrincipals());
                        node = node.getParent();
                        log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                    } else if (node.isNodeType("okm:note")) {
                        log.debug("{} Node is NOTE_TYPE", this.subject.getPrincipals());
                        node = node.getParent().getParent();
                        log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                    } else if (node.isNodeType("nt:frozenNode")) {
                        log.debug("{} Node is FROZEN_NODE", this.subject.getPrincipals());
                        realNodeId = node.getProperty("jcr:frozenUuid").getString();
                        node = systemSession.getNodeByUUID(realNodeId).getParent();
                        log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                    } else if (node.isNodeType("nt:version")) {
                        log.debug("{} Node is VERSION", this.subject.getPrincipals());
                        Node frozenNode = node.getNode("jcr:frozenNode");
                        log.debug("{} Frozen node -> {}", this.subject.getPrincipals(), (Object)frozenNode.getPath());
                        String realNodeId2 = frozenNode.getProperty("jcr:frozenUuid").getString();
                        try {
                            node = systemSession.getNodeByUUID(realNodeId2).getParent();
                            log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                        }
                        catch (ItemNotFoundException e) {
                            log.warn("Real node not found, so we are purging: {}", (Object)realNodeId2);
                            access = true;
                        }
                    } else if (node.isNodeType("nt:versionHistory")) {
                        log.debug("{} Node is VERSION_HISTORY", this.subject.getPrincipals());
                        realNodeId = node.getProperty("jcr:versionableUuid").getString();
                        node = systemSession.getNodeByUUID(realNodeId).getParent();
                        log.debug("{} Real -> {}", this.subject.getPrincipals(), (Object)node.getPath());
                    }
                    if (!access) {
                        if ((permissions & 1) != 0) {
                            try {
                                access = this.checkProperties((Node)node, "okm:authUsersRead", "okm:authRolesRead");
                            }
                            catch (PathNotFoundException e) {
                                log.warn("{} PathNotFoundException({}) in {}", new Object[]{this.subject.getPrincipals(), e.getMessage(), node.getPrimaryNodeType().getName()});
                                access = true;
                            }
                        } else if ((permissions & 4) != 0 || (permissions & 2) != 0) {
                            try {
                                access = this.checkProperties((Node)node, "okm:authUsersWrite", "okm:authRolesWrite");
                            }
                            catch (PathNotFoundException e) {
                                log.debug("{} PropertyNotFoundException({}) in {}", new Object[]{this.subject.getPrincipals(), e.getMessage(), node.getPrimaryNodeType().getName()});
                                access = true;
                            }
                        } else if ((permissions & 8) != 0 || (permissions & 0x10) != 0) {
                            try {
                                access = this.checkProperties((Node)node, "okm:authUsersDelete", "okm:authRolesDelete");
                            }
                            catch (PathNotFoundException e) {
                                log.debug("{} PropertyNotFoundException({}) in {}", new Object[]{this.subject.getPrincipals(), e.getMessage(), node.getPrimaryNodeType().getName()});
                                access = true;
                            }
                        } else if ((permissions & 0x40) != 0) {
                            try {
                                access = this.checkProperties((Node)node, "okm:authUsersSecurity", "okm:authRolesSecurity");
                            }
                            catch (PathNotFoundException e) {
                                log.debug("{} PropertyNotFoundException({}) in {}", new Object[]{this.subject.getPrincipals(), e.getMessage(), node.getPrimaryNodeType().getName()});
                                access = true;
                            }
                        }
                    }
                }
            }
        }
        log.debug("checkAccess: {}", (Object)access);
        return access;
    }

    private boolean checkProperties(Node node, String userProperty, String roleProperty) throws ValueFormatException, RepositoryException, PathNotFoundException {
        log.debug("checkProperties({})", (Object)node);
        Value[] users = node.getProperty(userProperty).getValues();
        boolean access = false;
        for (int i = 0; i < users.length; ++i) {
            log.debug("{} User: {}", (Object)userProperty, (Object)users[i].getString());
            if (!this.principalUser.equals(users[i].getString())) continue;
            access = true;
            break;
        }
        if (!access) {
            Value[] roles = node.getProperty(roleProperty).getValues();
            for (int i = 0; i < roles.length; ++i) {
                log.debug("{} Rol: {}", (Object)roleProperty, (Object)roles[i].getString());
                if (!this.principalRoles.contains(roles[i].getString())) continue;
                access = true;
                break;
            }
        }
        log.debug("checkProperties: {}", (Object)access);
        return access;
    }

    private int deprecatedPermissionsToNewApi(int permissions) {
        boolean read = (permissions & 1) != 0;
        boolean write = (permissions & 2) != 0;
        boolean remove = (permissions & 4) != 0;
        int result = 0;
        if (read) {
            result |= 1;
        }
        if (write) {
            result |= 4;
            result |= 2;
        }
        if (remove) {
            result |= 8;
            result |= 0x10;
        }
        return result;
    }

    private String permissionsToString(int permissions) {
        StringBuilder sb = new StringBuilder();
        if (permissions != 0) {
            if ((permissions & 4) != 0) {
                sb.append("add_node ");
            }
            if ((permissions & 1) != 0) {
                sb.append("read ");
            }
            if ((permissions & 8) != 0) {
                sb.append("remove_node ");
            }
            if ((permissions & 0x10) != 0) {
                sb.append("remove_property ");
            }
            if ((permissions & 2) != 0) {
                sb.append("set_property ");
            }
            if ((permissions & 0x20) != 0) {
                sb.append("read_ac ");
            }
            if ((permissions & 0x40) != 0) {
                sb.append("modify_ac ");
            }
        }
        return sb.toString();
    }
}

