/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.core.Config;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.MailUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMEventListener
implements EventListener {
    private static Logger log = LoggerFactory.getLogger(OKMEventListener.class);

    public void onEvent(EventIterator arg0) {
        Session system = DirectRepositoryModule.getSystemSession();
        while (arg0.hasNext()) {
            Event evn = arg0.nextEvent();
            String eventType = "";
            try {
                if (evn.getPath().endsWith("okm:content") || evn.getPath().endsWith("okm:size") || evn.getPath().endsWith("okm:author") || evn.getPath().endsWith("jcr:lastModified") || evn.getPath().endsWith("jcr:lockOwner") || evn.getPath().endsWith("jcr:lockIsDeep") || evn.getPath().endsWith("jcr:isCheckedOut") || evn.getPath().endsWith("jcr:baseVersion") || evn.getPath().endsWith("jcr:predecessors")) continue;
                switch (evn.getType()) {
                    case 1: {
                        eventType = "NODE_ADDED";
                        break;
                    }
                    case 2: {
                        eventType = "NODE_REMOVED";
                        break;
                    }
                    case 4: {
                        eventType = "PROPERTY_ADDED";
                        break;
                    }
                    case 8: {
                        eventType = "PROPERTY_REMOVED";
                        break;
                    }
                    case 16: {
                        eventType = evn.getPath().endsWith("jcr:data") ? "NODE_CHANGED" : "PROPERTY_CHANGED";
                    }
                }
                log.info("***** Type: " + eventType + " - " + evn.getPath());
                if (evn.getType() != 2 && evn.getType() != 8) {
                    Item item = system.getItem(evn.getPath());
                    while (!item.isNode()) {
                        log.info("[1][1] " + item.getPath());
                        item = item.getParent();
                    }
                    Node node = (Node)item;
                    while (!node.isNodeType("mix:notification")) {
                        log.info("[2][2] " + node.getPath());
                        node = node.getParent();
                    }
                    Value[] subscriptors = node.getProperty("okm:subscriptors").getValues();
                    for (int i = 0; i < subscriptors.length; ++i) {
                        log.info("[3][3] " + subscriptors[i].getString());
                    }
                }
                ArrayList<String> emails = new ArrayList<String>();
                String body = "URL: " + Config.APPLICATION_URL + "?nodePath=" + URLEncoder.encode(evn.getPath(), "UTF-8") + "\n" + "File: " + evn.getPath() + "\n" + "User: " + evn.getUserID() + "\n" + "Action: " + eventType;
                MailUtils.sendMessage("monkiki@gmail.com", emails, "OpenKM notification", body);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
    }
}

