/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.CredentialsCallback;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.UserPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OKMLoginModule
implements LoginModule {
    private static Logger log = LoggerFactory.getLogger(OKMLoginModule.class);
    private String usersRsrcName = "users.properties";
    private String rolesRsrcName = "roles.properties";
    private Properties users;
    private Properties roles;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private final Set<Principal> principals = new HashSet<Principal>();
    private String defaultUserId = null;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        log.debug("initialize(" + subject + ", " + callbackHandler + ", " + sharedState + ", " + options + ")");
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        try {
            this.users = OKMLoginModule.loadProperties(this.usersRsrcName);
            this.roles = OKMLoginModule.loadProperties(this.rolesRsrcName);
        }
        catch (Exception e) {
            log.error("Failed to load users/passwords/role files", (Throwable)e);
        }
        log.debug("initialize: void");
    }

    @Override
    public boolean login() throws LoginException {
        log.debug("login()");
        if (this.callbackHandler == null) {
            throw new LoginException("no CallbackHandler available");
        }
        if (this.users == null) {
            throw new LoginException("Missing users.properties file.");
        }
        if (this.roles == null) {
            throw new LoginException("Missing roles.properties file.");
        }
        boolean authenticated = false;
        this.principals.clear();
        try {
            CredentialsCallback ccb = new CredentialsCallback();
            this.callbackHandler.handle(new Callback[]{ccb});
            Credentials creds = ccb.getCredentials();
            if (creds != null) {
                if (creds instanceof SimpleCredentials) {
                    SimpleCredentials sc = (SimpleCredentials)creds;
                    Object attr = sc.getAttribute("org.apache.jackrabbit.core.security.impersonator");
                    if (attr != null && attr instanceof Subject) {
                        Subject impersonator = (Subject)attr;
                        log.debug("***** RARO ******");
                        log.debug(impersonator.toString());
                        log.debug("***** RARO ******");
                    } else {
                        log.debug("***********");
                        log.debug(sc.getUserID() + " -> " + new String(sc.getPassword()));
                        log.debug("***********");
                        if (this.users.getProperty(sc.getUserID()).equals(new String(sc.getPassword()))) {
                            log.debug("*********** BIEN");
                            authenticated = true;
                        } else {
                            log.debug("*********** MAL");
                            authenticated = false;
                        }
                    }
                    if ("anonymousUserId".equals(sc.getUserID())) {
                        this.principals.add((Principal)new AnonymousPrincipal());
                        authenticated = true;
                    } else {
                        this.principals.add((Principal)new UserPrincipal(sc.getUserID()));
                        authenticated = true;
                    }
                }
            } else if (this.defaultUserId != null) {
                this.principals.add((Principal)new SystemPrincipal());
                authenticated = true;
            } else {
                this.principals.add((Principal)new AnonymousPrincipal());
                authenticated = true;
            }
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getCallback().toString() + " not available");
        }
        if (!authenticated) {
            this.principals.clear();
            throw new FailedLoginException();
        }
        boolean ok = !this.principals.isEmpty();
        log.debug("login: " + ok);
        return ok;
    }

    @Override
    public boolean commit() throws LoginException {
        boolean ok;
        log.debug("commit()");
        if (this.principals.isEmpty()) {
            ok = false;
        } else {
            this.subject.getPrincipals().addAll(this.principals);
            ok = true;
        }
        log.debug("commit: " + ok);
        return ok;
    }

    @Override
    public boolean abort() throws LoginException {
        boolean ok;
        log.debug("abort()");
        if (this.principals.isEmpty()) {
            ok = false;
        } else {
            this.logout();
            ok = true;
        }
        log.debug("abort: " + ok);
        return ok;
    }

    @Override
    public boolean logout() throws LoginException {
        log.debug("logout()");
        boolean ok = true;
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        log.debug("logout: " + ok);
        return ok;
    }

    static Properties loadProperties(String propertiesName) throws IOException {
        log.debug("loadProperties(" + propertiesName + ")");
        Properties bundle = null;
        FileInputStream is = new FileInputStream(propertiesName);
        if (is == null) {
            throw new IOException("Properties file " + propertiesName + " not avilable");
        }
        bundle = new Properties();
        bundle.load(is);
        log.debug("loadProperties: " + bundle);
        return bundle;
    }
}

