/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.api.OKMStats;
import com.openkm.bean.StatsInfo;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInfo
extends TimerTask {
    private static Logger log = LoggerFactory.getLogger(RepositoryInfo.class);
    private static StatsInfo documentsByContext = new StatsInfo();
    private static StatsInfo foldersByContext = new StatsInfo();
    private static StatsInfo documentsSizeByContext = new StatsInfo();
    private static volatile boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (running) {
            log.warn("*** Repository info already running ***");
        } else {
            running = true;
            log.debug("*** Begin repository info ***");
            try {
                String systemToken = JcrSessionManager.getInstance().getSystemToken();
                OKMStats okmStats = OKMStats.getInstance();
                try {
                    documentsByContext = okmStats.getDocumentsByContext(systemToken);
                    foldersByContext = okmStats.getFoldersByContext(systemToken);
                    documentsSizeByContext = okmStats.getDocumentsSizeByContext(systemToken);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                catch (DatabaseException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                running = false;
            }
            log.debug("*** End repository info ***");
        }
    }

    public static StatsInfo getDocumentsByContext() {
        return documentsByContext;
    }

    public static StatsInfo getFoldersByContext() {
        return foldersByContext;
    }

    public static StatsInfo getDocumentsSizeByContext() {
        return documentsSizeByContext;
    }
}

