/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.api.OKMAuth;
import com.openkm.core.AccessDeniedException;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.ItemExistsException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.PathNotFoundException;
import com.openkm.core.RepositoryException;
import com.openkm.core.UserQuotaExceededException;
import com.openkm.core.VirusDetectedException;
import com.openkm.dao.MailAccountDAO;
import com.openkm.dao.bean.MailAccount;
import com.openkm.extension.core.ExtensionException;
import com.openkm.principal.PrincipalAdapterException;
import com.openkm.util.MailUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserMailImporter
extends TimerTask {
    private static Logger log = LoggerFactory.getLogger(UserMailImporter.class);
    private static volatile boolean running = false;
    private List<String> exceptionMessages = new ArrayList<String>();

    public boolean isRunning() {
        return running;
    }

    public List<String> getExceptionMessages() {
        return this.exceptionMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (running) {
            log.warn("*** User mail importer already running ***");
        } else {
            running = true;
            this.exceptionMessages = new ArrayList<String>();
            log.info("*** User mail importer activated ***");
            try {
                if (Config.SYSTEM_READONLY) {
                    this.exceptionMessages.add("Warning: System in read-only mode");
                    log.warn("*** System in read-only mode ***");
                } else {
                    String systemToken = JcrSessionManager.getInstance().getSystemToken();
                    List<String> users = OKMAuth.getInstance().getUsers(systemToken);
                    for (String uid : users) {
                        List<MailAccount> mailAccounts = MailAccountDAO.findByUser(uid, true);
                        for (MailAccount ma : mailAccounts) {
                            if (Config.SYSTEM_READONLY) {
                                this.exceptionMessages.add("Warning: System in read-only mode");
                                log.warn("*** System in read-only mode ***");
                                continue;
                            }
                            String exceptionMessage = MailUtils.importMessages(uid, ma);
                            if (exceptionMessage == null) continue;
                            this.exceptionMessages.add("Id: " + ma.getId() + ", User: " + ma.getUser() + ", Error: " + exceptionMessage);
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (DatabaseException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (PathNotFoundException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (ItemExistsException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (VirusDetectedException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (AccessDeniedException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (PrincipalAdapterException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (UserQuotaExceededException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            catch (ExtensionException e) {
                log.error(e.getMessage(), (Throwable)e);
                this.exceptionMessages.add(e.getMessage());
            }
            finally {
                running = false;
            }
        }
    }
}

