/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.core.Config;
import com.openkm.core.VirusDetectedException;
import com.openkm.module.direct.DirectDocumentModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirusDetection {
    private static Logger log = LoggerFactory.getLogger(DirectDocumentModule.class);

    public static void detect(File tmpFile) throws VirusDetectedException {
        try {
            log.debug("CMD: " + Config.SYSTEM_ANTIVIR + " " + tmpFile.getPath());
            ProcessBuilder pb = new ProcessBuilder(Config.SYSTEM_ANTIVIR, "--no-summary", tmpFile.getPath());
            Process process = pb.start();
            process.waitFor();
            String info = IOUtils.toString((InputStream)process.getInputStream());
            process.destroy();
            if (process.exitValue() == 1) {
                log.warn(info);
                info = info.substring(info.indexOf(58) + 1);
                throw new VirusDetectedException(info);
            }
        }
        catch (InterruptedException e) {
            log.warn("Failed to check for viruses", (Throwable)e);
        }
        catch (IOException e) {
            log.warn("Failed to check for viruses", (Throwable)e);
        }
    }
}

