/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.core;

import com.openkm.api.OKMAuth;
import com.openkm.bean.JcrSessionInfo;
import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.core.JcrSessionManager;
import com.openkm.core.RepositoryException;
import com.openkm.module.direct.DirectRepositoryModule;
import com.openkm.util.UserActivity;
import java.util.Calendar;
import java.util.TimerTask;
import javax.jcr.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watchdog
extends TimerTask {
    private static Logger log = LoggerFactory.getLogger(Watchdog.class);
    private static volatile boolean running = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (running) {
            log.warn("*** Watchdog already running ***");
        } else {
            running = true;
            log.debug("*** Watchdog activated ***");
            try {
                JcrSessionManager sm = JcrSessionManager.getInstance();
                for (String token : sm.getTokens()) {
                    JcrSessionInfo si = sm.getInfo(token);
                    Calendar expiration = (Calendar)si.getLastAccess().clone();
                    expiration.add(13, Config.SESSION_EXPIRATION);
                    log.debug(si.getSession().getUserID() + ", Expiration: " + expiration.getTime());
                    if (!Calendar.getInstance().after(expiration)) continue;
                    try {
                        Session system = DirectRepositoryModule.getSystemSession();
                        UserActivity.log(system.getUserID(), "SESSION_EXPIRATION", si.getSession().getUserID(), token + ", IDLE FROM: " + si.getLastAccess().getTime());
                        OKMAuth.getInstance().logout(token);
                    }
                    catch (RepositoryException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (DatabaseException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                running = false;
            }
        }
    }
}

