/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Activity;
import com.openkm.dao.bean.ActivityFilter;
import java.util.Calendar;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDAO {
    private static Logger log = LoggerFactory.getLogger(ActivityDAO.class);

    private ActivityDAO() {
    }

    public static void create(Activity activity) throws DatabaseException {
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)activity);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Activity> findByFilter(ActivityFilter filter) throws DatabaseException {
        log.debug("findByFilter({})", (Object)filter);
        String qs = "from Activity a where a.date between :begin and :end ";
        if (filter.getUser() != null && !filter.getUser().equals("")) {
            qs = qs + "and a.user=:user ";
        }
        if (filter.getAction() != null && !filter.getAction().equals("")) {
            qs = qs + "and a.action=:action ";
        }
        if (filter.getItem() != null && !filter.getItem().equals("")) {
            qs = qs + "and a.item=:item ";
        }
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setCalendar("begin", filter.getBegin());
            q.setCalendar("end", filter.getEnd());
            if (filter.getUser() != null && !filter.getUser().equals("")) {
                q.setString("user", filter.getUser());
            }
            if (filter.getAction() != null && !filter.getAction().equals("")) {
                q.setString("action", filter.getAction());
            }
            if (filter.getItem() != null && !filter.getItem().equals("")) {
                q.setString("item", filter.getItem());
            }
            List ret = q.list();
            log.debug("findByFilter: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Activity> findByFilterByItem(ActivityFilter filter) throws DatabaseException {
        log.debug("findByFilter({})", (Object)filter);
        String qs = "from Activity a where a.item=:item ";
        if (filter.getAction() != null && !filter.getAction().equals("")) {
            qs = qs + "and a.action=:action ";
        }
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("item", filter.getItem());
            if (filter.getAction() != null && !filter.getAction().equals("")) {
                q.setString("action", filter.getAction());
            }
            List ret = q.list();
            log.debug("findByFilterByItem: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Calendar getActivityDate(String user, String action, String item) throws DatabaseException {
        log.debug("getActivityDate({}, {}, {})", new Object[]{user, action, item});
        String qsAct = "select max(a.date) from Activity a where a.user=:user and a.action=:action and a.item=:item";
        String qsNoAct = "select max(a.date) from Activity a where (a.action='CREATE_DOCUMENT' or a.action='SET_DOCUMENT_CONTENT') and a.item=:item";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = null;
            if (action != null) {
                q = session.createQuery(qsAct);
                q.setString("user", user);
                q.setString("action", action);
                q.setString("item", item);
            } else {
                q = session.createQuery(qsNoAct);
                q.setString("item", item);
            }
            Calendar ret = (Calendar)q.setMaxResults(1).uniqueResult();
            if (ret == null) {
                ret = Calendar.getInstance();
            }
            log.debug("getActivityDate: {}", (Object)ret);
            Calendar calendar = ret;
            return calendar;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

