/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.QueryParams;
import com.openkm.dao.bean.Role;
import com.openkm.dao.bean.User;
import com.openkm.util.SecureStore;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDAO {
    private static Logger log = LoggerFactory.getLogger(AuthDAO.class);

    private AuthDAO() {
    }

    public static void createUser(User user) throws DatabaseException {
        log.debug("createUser({})", (Object)user);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            user.setPassword(SecureStore.md5Encode(user.getPassword().getBytes()));
            session.save((Object)user);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("createUser: void");
    }

    public static void updateUser(User user) throws DatabaseException {
        log.debug("updateUser({})", (Object)user);
        String qs = "select u.password from User u where u.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setParameter("id", (Object)user.getId());
            String password = (String)q.setMaxResults(1).uniqueResult();
            user.setPassword(password);
            session.update((Object)user);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateUser: void");
    }

    public static void activeUser(String usrId, boolean active) throws DatabaseException {
        log.debug("activeUser({}, {})", (Object)usrId, (Object)active);
        String qs = "update User u set u.active=:active where u.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setBoolean("active", active);
            q.setString("id", usrId);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("activeUser: void");
    }

    public static void updateUserPassword(String usrId, String usrPassword) throws DatabaseException {
        log.debug("updateUserPassword({}, {})", (Object)usrId, (Object)usrPassword);
        String qs = "update User u set u.password=:password where u.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            if (usrPassword != null && usrPassword.trim().length() > 0) {
                session = HibernateUtil.getSessionFactory().openSession();
                tx = session.beginTransaction();
                Query q = session.createQuery(qs);
                q.setString("password", SecureStore.md5Encode(usrPassword.getBytes()));
                q.setString("id", usrId);
                q.executeUpdate();
                HibernateUtil.commit(tx);
            }
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close(session);
        }
        log.debug("updateUserPassword: void");
    }

    public static void updateUserEmail(String usrId, String usrEmail) throws DatabaseException {
        log.debug("updateUserEmail({}, {})", (Object)usrId, (Object)usrEmail);
        String qs = "update User u set u.email=:email where u.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            if (usrEmail != null && usrEmail.trim().length() > 0) {
                session = HibernateUtil.getSessionFactory().openSession();
                tx = session.beginTransaction();
                Query q = session.createQuery(qs);
                q.setString("email", usrEmail);
                q.setString("id", usrId);
                q.executeUpdate();
                HibernateUtil.commit(tx);
            }
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close(session);
        }
        log.debug("updateUserEmail: void");
    }

    public static void deleteUser(String usrId) throws DatabaseException {
        log.debug("deleteUser({})", (Object)usrId);
        String qsMail = "delete from MailAccount ma where ma.user=:user";
        String qsTwitter = "delete from TwitterAccount ta where ta.user=:user";
        String qsBookmark = "delete from Bookmark bm where bm.user=:user";
        String qsConfig = "delete from UserConfig uc where uc.user=:user";
        String qsItems = "delete from UserItems ui where ui.user=:user";
        String qsSharedQuery = "from QueryParams qp where :user in elements(qp.shared)";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            User user = (User)session.load(User.class, (Serializable)((Object)usrId));
            session.delete((Object)user);
            Query qMail = session.createQuery(qsMail);
            qMail.setString("user", usrId);
            qMail.executeUpdate();
            Query qTwitter = session.createQuery(qsTwitter);
            qTwitter.setString("user", usrId);
            qTwitter.executeUpdate();
            Query qBookmark = session.createQuery(qsBookmark);
            qBookmark.setString("user", usrId);
            qBookmark.executeUpdate();
            Query qConfig = session.createQuery(qsConfig);
            qConfig.setString("user", usrId);
            qConfig.executeUpdate();
            Query qItems = session.createQuery(qsItems);
            qItems.setString("user", usrId);
            qItems.executeUpdate();
            Query qSharedQuery = session.createQuery(qsSharedQuery);
            qSharedQuery.setString("user", usrId);
            for (QueryParams qp : qSharedQuery.list()) {
                qp.getShared().remove(usrId);
                session.update((Object)qp);
            }
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteUser: void");
    }

    public static List<User> findAllUsers(boolean filterByActive) throws DatabaseException {
        log.debug("findAllUsers({})", (Object)filterByActive);
        String qs = "from User u " + (filterByActive ? "where u.active=:active" : "") + " order by u.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findAllUsers: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<User> findUsersByRole(String rolId, boolean filterByActive) throws DatabaseException {
        log.debug("findUsersByRole({}, {})", (Object)rolId, (Object)filterByActive);
        String qs = "select u from User u, Role r where r.id=:rolId and r in elements(u.roles) " + (filterByActive ? "and u.active=:active" : "") + " order by u.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("rolId", rolId);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findUsersByRole: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Role> findRolesByUser(String usrId, boolean filterByActive) throws DatabaseException {
        log.debug("findRolesByUser({}, {})", (Object)usrId, (Object)filterByActive);
        String qs = "select r from User u, Role r where u.id=:usrId and r in elements(u.roles) " + (filterByActive ? "and r.active=:active" : "") + " order by r.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("usrId", usrId);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findRolesByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static User findUserByPk(String usrId) throws DatabaseException {
        log.debug("findUserByPk({})", (Object)usrId);
        String qs = "from User u where u.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("id", usrId);
            User ret = (User)q.setMaxResults(1).uniqueResult();
            log.debug("findUserByPk: {}", (Object)ret);
            User user = ret;
            return user;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void createRole(Role role) throws DatabaseException {
        log.debug("createRole({})", (Object)role);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)role);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("createRole: void");
    }

    public static void updateRole(Role role) throws DatabaseException {
        log.debug("updateRole({})", (Object)role);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)role);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateRole: void");
    }

    public static void activeRole(String rolId, boolean active) throws DatabaseException {
        log.debug("activeRole({}, {})", (Object)rolId, (Object)active);
        String qs = "update Role r set r.active=:active where r.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setBoolean("active", active);
            q.setString("id", rolId);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("activeRole: void");
    }

    public static void deleteRole(String rolId) throws DatabaseException {
        log.debug("deleteRole({})", (Object)rolId);
        String qs = "delete from OKM_USER_ROLE where UR_ROLE=:rolId";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Role role = (Role)session.load(Role.class, (Serializable)((Object)rolId));
            session.delete((Object)role);
            SQLQuery q = session.createSQLQuery(qs);
            q.setString("rolId", rolId);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteRole: void");
    }

    public static List<Role> findAllRoles() throws DatabaseException {
        log.debug("findAllRoles()");
        String qs = "from Role r order by r.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAllRoles: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Role findRoleByPk(String rolId) throws DatabaseException {
        log.debug("findRoleByPk({})", (Object)rolId);
        String qs = "from Role r where r.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("id", rolId);
            Role ret = (Role)q.setMaxResults(1).uniqueResult();
            log.debug("findRoleByPk: {}", (Object)ret);
            Role role = ret;
            return role;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void grantRole(String usrId, String rolId) throws DatabaseException {
        log.debug("grantRole({}, {})", (Object)usrId, (Object)rolId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            User user = (User)session.load(User.class, (Serializable)((Object)usrId));
            Role role = (Role)session.load(Role.class, (Serializable)((Object)rolId));
            user.getRoles().add(role);
            session.update((Object)user);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("grantRole: void");
    }

    public void revokeRole(String usrId, String rolId) throws DatabaseException {
        log.debug("revokeRole({}, {})", (Object)usrId, (Object)rolId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            User user = (User)session.load(User.class, (Serializable)((Object)usrId));
            Role role = (Role)session.load(Role.class, (Serializable)((Object)rolId));
            user.getRoles().remove(role);
            session.update((Object)user);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("revokeRole: void");
    }
}

