/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Bookmark;
import com.openkm.jcr.JCRUtils;
import java.io.Serializable;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkDAO {
    private static Logger log = LoggerFactory.getLogger(BookmarkDAO.class);

    private BookmarkDAO() {
    }

    public static void create(Bookmark bm) throws DatabaseException {
        log.debug("create({})", (Object)bm);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)bm);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }

    public static void update(Bookmark bm) throws DatabaseException {
        log.debug("update({})", (Object)bm);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)bm);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int bmId) throws DatabaseException {
        log.debug("delete({})", (Object)bmId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Bookmark bm = (Bookmark)session.load(Bookmark.class, (Serializable)Integer.valueOf(bmId));
            session.delete((Object)bm);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<Bookmark> findByUser(Session jcrSession, String usrId) throws DatabaseException, RepositoryException {
        log.debug("findByUser({}, {})", (Object)jcrSession, (Object)usrId);
        String qs = "from Bookmark bm where bm.user=:user order by bm.id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("user", usrId);
            List ret = q.list();
            for (Bookmark bm : ret) {
                try {
                    Node node = jcrSession.getNodeByUUID(bm.getUuid());
                    String nType = JCRUtils.getNodeType(node);
                    bm.setPath(node.getPath());
                    if (nType.equals(bm.getType())) continue;
                    bm.setType(JCRUtils.getNodeType(node));
                    session.update((Object)ret);
                }
                catch (ItemNotFoundException e) {
                    Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                    bm.setPath(okmRoot.getPath());
                    bm.setUuid(okmRoot.getUUID());
                    bm.setType("okm:folder");
                    session.save((Object)bm);
                }
            }
            HibernateUtil.commit(tx);
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (javax.jcr.RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Bookmark findByPk(Session jcrSession, int bmId) throws DatabaseException, RepositoryException {
        log.debug("findByPk({}, {})", (Object)jcrSession, (Object)bmId);
        String qs = "from Bookmark bm where bm.id=:id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setInteger("id", bmId);
            Bookmark ret = (Bookmark)q.setMaxResults(1).uniqueResult();
            try {
                Node node = jcrSession.getNodeByUUID(ret.getUuid());
                String nType = JCRUtils.getNodeType(node);
                ret.setPath(node.getPath());
                if (!nType.equals(ret.getType())) {
                    ret.setType(JCRUtils.getNodeType(node));
                    session.update((Object)ret);
                }
            }
            catch (ItemNotFoundException e) {
                Node okmRoot = jcrSession.getRootNode().getNode("okm:root");
                ret.setPath(okmRoot.getPath());
                ret.setUuid(okmRoot.getUUID());
                ret.setType("okm:folder");
                session.save((Object)ret);
            }
            HibernateUtil.commit(tx);
            log.debug("findByPk: {}", (Object)ret);
            Bookmark bookmark = ret;
            return bookmark;
        }
        catch (javax.jcr.RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

