/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.google.gson.Gson;
import com.openkm.bean.StoredFile;
import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Config;
import com.openkm.jcr.JCRUtils;
import com.openkm.util.SecureStore;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDAO {
    private static Logger log = LoggerFactory.getLogger(ConfigDAO.class);

    private ConfigDAO() {
    }

    public static void create(Config cfg) throws DatabaseException {
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)cfg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(Config cfg) throws DatabaseException {
        log.debug("update({})", (Object)cfg);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)cfg);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(String key) throws DatabaseException {
        log.debug("delete({})", (Object)key);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Config mt = (Config)session.load(Config.class, (Serializable)((Object)key));
            session.delete((Object)mt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static Config findByPk(String key) throws DatabaseException {
        log.debug("findByPk({})", (Object)key);
        String qs = "from Config cfg where cfg.key=:key";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("key", key);
            Config ret = (Config)q.setMaxResults(1).uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("findByPk: {}", (Object)ret);
            Config config = ret;
            return config;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    private static String getProperty(String key, String value, String type) throws DatabaseException {
        log.debug("getProperty({}, {}, {})", new Object[]{key, value, type});
        String qs = "from Config cfg where cfg.key=:key";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("key", key);
            Config ret = (Config)q.setMaxResults(1).uniqueResult();
            if (ret == null) {
                ret = new Config();
                ret.setKey(key);
                ret.setType(type);
                ret.setValue(value);
                session.save((Object)ret);
            } else if (ret.getValue() == null) {
                ret.setValue("");
            }
            HibernateUtil.commit(tx);
            log.debug("getProperty: {}", (Object)ret);
            String string = ret.getValue();
            return string;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static String getString(String key, String value) throws DatabaseException {
        return ConfigDAO.getProperty(key, value, "string");
    }

    public static String getText(String key, String value) throws DatabaseException {
        return ConfigDAO.getProperty(key, value, "text");
    }

    public static boolean getBoolean(String key, boolean value) throws DatabaseException {
        return "true".equalsIgnoreCase(ConfigDAO.getProperty(key, Boolean.toString(value), "boolean"));
    }

    public static int getInteger(String key, int value) throws DatabaseException {
        return Integer.parseInt(ConfigDAO.getProperty(key, Integer.toString(value), "integer"));
    }

    public static int getLong(String key, long value) throws DatabaseException {
        return Integer.parseInt(ConfigDAO.getProperty(key, Long.toString(value), "long"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StoredFile getFile(String key, String path) throws DatabaseException, IOException {
        InputStream is = null;
        try {
            is = Config.class.getResourceAsStream(path);
            StoredFile stFile = new StoredFile();
            stFile.setContent(SecureStore.b64Encode(IOUtils.toByteArray((InputStream)is)));
            stFile.setName(JCRUtils.getName(path));
            stFile.setMime(com.openkm.core.Config.mimeTypes.getContentType(stFile.getName()));
            ConfigDAO.getProperty(key, new Gson().toJson((Object)stFile), "file");
            StoredFile storedFile = stFile;
            return storedFile;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static List<Config> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from Config cfg order by cfg.key";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

