/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.CronTab;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CronTabDAO {
    private static Logger log = LoggerFactory.getLogger(CronTabDAO.class);

    private CronTabDAO() {
    }

    public static int create(CronTab ct) throws DatabaseException {
        log.debug("create({})", (Object)ct);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)ct);
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(CronTab ct) throws DatabaseException {
        log.debug("update({})", (Object)ct);
        String qs = "select ct.fileContent, ct.fileName, ct.fileMime, ct.lastBegin, ct.lastEnd from CronTab ct where ct.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            if (ct.getFileContent() == null || ct.getFileContent().length() == 0) {
                Query q = session.createQuery(qs);
                q.setParameter("id", (Object)ct.getId());
                Object[] data = (Object[])q.setMaxResults(1).uniqueResult();
                ct.setFileContent((String)data[0]);
                ct.setFileName((String)data[1]);
                ct.setFileMime((String)data[2]);
                ct.setLastBegin((Calendar)data[3]);
                ct.setLastEnd((Calendar)data[4]);
            }
            session.update((Object)ct);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int ctId) throws DatabaseException {
        log.debug("delete({})", (Object)ctId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            CronTab ct = (CronTab)session.load(CronTab.class, (Serializable)Integer.valueOf(ctId));
            session.delete((Object)ct);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static CronTab findByPk(int ctId) throws DatabaseException {
        log.debug("findByPk({})", (Object)ctId);
        String qs = "from CronTab ct where ct.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", ctId);
            CronTab ret = (CronTab)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            CronTab cronTab = ret;
            return cronTab;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<CronTab> findAll() throws DatabaseException {
        log.debug("findAll()");
        String qs = "from CronTab ct order by ct.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void setLastBegin(int ctId) throws DatabaseException {
        log.debug("setLastBegin({})", (Object)ctId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            CronTab ct = (CronTab)session.load(CronTab.class, (Serializable)Integer.valueOf(ctId));
            ct.setLastBegin(Calendar.getInstance());
            session.update((Object)ct);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("setLastBegin: void");
    }

    public static void setLastEnd(int ctId) throws DatabaseException {
        log.debug("setLastEnd({})", (Object)ctId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            CronTab ct = (CronTab)session.load(CronTab.class, (Serializable)Integer.valueOf(ctId));
            ct.setLastEnd(Calendar.getInstance());
            session.update((Object)ct);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("setLastEnd: void");
    }
}

