/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Dashboard;
import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardDAO {
    private static Logger log = LoggerFactory.getLogger(DashboardDAO.class);

    private DashboardDAO() {
    }

    public Dashboard findByPk(int dsId) throws DatabaseException {
        log.debug("findByPk({})", (Object)dsId);
        String qs = "from Dashboard db where db.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", dsId);
            List results = q.list();
            Dashboard ret = null;
            if (results.size() == 1) {
                ret = (Dashboard)results.get(0);
            }
            log.debug("findByPk: {}", ret);
            Dashboard dashboard = ret;
            return dashboard;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void createIfNew(Dashboard db) throws DatabaseException {
        String qs = "from Dashboard db where db.user=:user and db.source=:source and db.node=:node and db.date=:date";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("user", db.getUser());
            q.setString("source", db.getSource());
            q.setString("node", db.getNode());
            q.setCalendar("date", db.getDate());
            if (q.list().isEmpty()) {
                session.save((Object)db);
            }
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public void delete(int dsId) throws DatabaseException {
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Dashboard ds = (Dashboard)session.load(Dashboard.class, (Serializable)Integer.valueOf(dsId));
            session.delete((Object)ds);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Dashboard> findByUserSource(String user, String source) throws DatabaseException {
        log.debug("findByUserSource({}, {})", (Object)user, (Object)source);
        String qs = "from Dashboard db where db.user=:user and db.source=:source";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            q.setString("source", source);
            List ret = q.list();
            log.debug("findByUserSource: " + ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void deleteVisitedNodes(String user, String source) throws DatabaseException {
        log.debug("deleteVisitedNodes({}, {})", (Object)user, (Object)source);
        String qs = "delete from Dashboard db where db.user=:user and db.source=:source";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            q.setString("source", source);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteVisitedNodes: void");
    }

    public static void purgeOldVisitedNode(String user, String source, String node, Calendar date) throws DatabaseException {
        log.debug("purgeOldVisitedNode({}, {}, {}, {})", new Object[]{user, source, node, date});
        String qs = "delete from Dashboard db where db.user=:user and db.source=:source and db.node=:node and db.date=:date";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            q.setString("source", source);
            q.setString("node", node);
            q.setCalendar("date", date);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("purgeOldVisitedNode: void");
    }
}

