/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.DatabaseMetadataSequence;
import com.openkm.dao.bean.DatabaseMetadataType;
import com.openkm.dao.bean.DatabaseMetadataValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseMetadataDAO {
    private static Logger log = LoggerFactory.getLogger(DatabaseMetadataDAO.class);

    private DatabaseMetadataDAO() {
    }

    public static long createValue(DatabaseMetadataValue dmv) throws DatabaseException {
        log.debug("createValue({})", (Object)dmv);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Long id = (Long)session.save((Object)dmv);
            HibernateUtil.commit(tx);
            log.debug("createValue: {}", (Object)id);
            long l = id;
            return l;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void updateValue(DatabaseMetadataValue dmv) throws DatabaseException {
        log.debug("updateValue({})", (Object)dmv);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)dmv);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateValue: void");
    }

    public static void deleteValue(long dmvId) throws DatabaseException {
        log.debug("deleteValue({})", (Object)dmvId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            DatabaseMetadataValue dmv = (DatabaseMetadataValue)session.load(DatabaseMetadataValue.class, (Serializable)Long.valueOf(dmvId));
            session.delete((Object)dmv);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteValue: void");
    }

    public static List<DatabaseMetadataValue> findAllValues(String table) throws DatabaseException {
        log.debug("findAllValues({})", (Object)table);
        String qs = "from DatabaseMetadataValue dmv where dmv.table=:table order by dmv.id asc";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("table", table);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findAllValues: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static DatabaseMetadataValue findValueByPk(String table, long id) throws DatabaseException {
        log.debug("findValueByPk({}, {})", (Object)table, (Object)id);
        String qs = "from DatabaseMetadataValue dmv where dmv.table=:table and dmv.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("table", table);
            q.setLong("id", id);
            DatabaseMetadataValue ret = (DatabaseMetadataValue)q.setMaxResults(1).uniqueResult();
            log.debug("findValueByPk: {}", (Object)ret);
            DatabaseMetadataValue databaseMetadataValue = ret;
            return databaseMetadataValue;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static int executeValueUpdate(String query) throws DatabaseException {
        log.debug("executeValueUpdate({})", (Object)query);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            int ret = q.executeUpdate();
            HibernateUtil.commit(tx);
            log.debug("executeValueUpdate: {}", (Object)ret);
            int n = ret;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<DatabaseMetadataValue> executeValueQuery(String query) throws DatabaseException {
        log.debug("executeValueQuery({})", (Object)query);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("executeValueQuery: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static DatabaseMetadataValue executeValueQueryUnique(String query) throws DatabaseException {
        log.debug("executeValueQueryUnique({})", (Object)query);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            DatabaseMetadataValue ret = (DatabaseMetadataValue)q.uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("executeValueQueryUnique: {}", (Object)ret);
            DatabaseMetadataValue databaseMetadataValue = ret;
            return databaseMetadataValue;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<DatabaseMetadataValue[]> executeMultiValueQuery(String query) throws DatabaseException {
        log.debug("executeMultiValueQuery({})", (Object)query);
        ArrayList<DatabaseMetadataValue[]> ret = new ArrayList<DatabaseMetadataValue[]>();
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            for (Object obj : q.list()) {
                if (obj instanceof Object[]) {
                    Object[] objAry = (Object[])obj;
                    DatabaseMetadataValue[] tmp = new DatabaseMetadataValue[objAry.length];
                    for (int i = 0; i < objAry.length; ++i) {
                        if (!(objAry[i] instanceof DatabaseMetadataValue)) continue;
                        tmp[i] = (DatabaseMetadataValue)objAry[i];
                    }
                    ret.add(tmp);
                    continue;
                }
                if (!(obj instanceof DatabaseMetadataValue)) continue;
                DatabaseMetadataValue[] tmp = new DatabaseMetadataValue[]{(DatabaseMetadataValue)obj};
                ret.add(tmp);
            }
            HibernateUtil.commit(tx);
            log.debug("executeMultiValueQuery: {}", ret);
            ArrayList<DatabaseMetadataValue[]> arrayList = ret;
            return arrayList;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static int createType(DatabaseMetadataType dmt) throws DatabaseException {
        log.debug("createType({})", (Object)dmt);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)dmt);
            HibernateUtil.commit(tx);
            log.debug("createType: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void updateType(DatabaseMetadataType dmt) throws DatabaseException {
        log.debug("updateType({})", (Object)dmt);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)dmt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateType: void");
    }

    public static void deleteType(int dmtId) throws DatabaseException {
        log.debug("deleteType({})", (Object)dmtId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            DatabaseMetadataType emt = (DatabaseMetadataType)session.load(DatabaseMetadataType.class, (Serializable)Integer.valueOf(dmtId));
            session.delete((Object)emt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteType: void");
    }

    public static List<DatabaseMetadataType> findAllTypes(String table) throws DatabaseException {
        log.debug("findAllTypes({})", (Object)table);
        String qs = "from DatabaseMetadataType dmt where dmt.table=:table order by dmt.id asc";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("table", table);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findAllTypes: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static long getNextSequenceValue(String table, String column) throws DatabaseException {
        log.debug("getNextSequenceValue({}, {})", (Object)table, (Object)column);
        String qs = "from DatabaseMetadataSequence dms where dms.table=:table and dms.column=:column";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("table", table);
            q.setString("column", column);
            DatabaseMetadataSequence dms = (DatabaseMetadataSequence)q.setMaxResults(1).uniqueResult();
            if (dms != null) {
                dms.setValue(dms.getValue() + 1L);
                session.update((Object)dms);
            } else {
                dms = new DatabaseMetadataSequence();
                dms.setTable(table);
                dms.setColumn(column);
                dms.setValue(1L);
                session.save((Object)dms);
            }
            HibernateUtil.commit(tx);
            log.debug("getNextSequenceValue: {}", (Object)dms.getValue());
            long l = dms.getValue();
            return l;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

