/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.DocumentFilter;
import com.openkm.dao.bean.DocumentFilterRule;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentFilterDAO {
    private static Logger log = LoggerFactory.getLogger(DocumentFilterDAO.class);

    private DocumentFilterDAO() {
    }

    public static void create(DocumentFilter df) throws DatabaseException {
        log.debug("create({})", (Object)df);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)df);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }

    public static void update(DocumentFilter df) throws DatabaseException {
        log.debug("update({})", (Object)df);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)df);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int dfId) throws DatabaseException {
        log.debug("delete({})", (Object)dfId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            DocumentFilter df = (DocumentFilter)session.load(DocumentFilter.class, (Serializable)Integer.valueOf(dfId));
            session.delete((Object)df);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<DocumentFilter> findAll(boolean filterByActive) throws DatabaseException {
        log.debug("findAll({})", (Object)filterByActive);
        String qs = "from DocumentFilter df " + (filterByActive ? "where df.active=:active" : "") + " order by df.id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static DocumentFilter findByPk(int dfId) throws DatabaseException {
        log.debug("findByPk({})", (Object)dfId);
        String qs = "from DocumentFilter df where df.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", dfId);
            DocumentFilter ret = (DocumentFilter)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            DocumentFilter documentFilter = ret;
            return documentFilter;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void updateRule(DocumentFilterRule dfr) throws DatabaseException {
        log.debug("updateRule({})", (Object)dfr);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)dfr);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateRule: void");
    }

    public static void deleteRule(int dfrId) throws DatabaseException {
        log.debug("deleteRule({})", (Object)dfrId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            DocumentFilterRule dfr = (DocumentFilterRule)session.load(DocumentFilterRule.class, (Serializable)Integer.valueOf(dfrId));
            session.delete((Object)dfr);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteRule: void");
    }

    public static DocumentFilterRule findRuleByPk(int dfrId) throws DatabaseException {
        log.debug("findRuleByPk({})", (Object)dfrId);
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            DocumentFilterRule ret = (DocumentFilterRule)session.load(DocumentFilterRule.class, (Serializable)Integer.valueOf(dfrId));
            log.debug("findRuleByPk: {}", (Object)ret);
            DocumentFilterRule documentFilterRule = ret;
            return documentFilterRule;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

