/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.Config;
import com.openkm.dao.LegacyDAO;
import com.openkm.dao.bean.DatabaseMetadataSequence;
import com.openkm.dao.bean.DatabaseMetadataType;
import com.openkm.dao.bean.DatabaseMetadataValue;
import com.openkm.util.DatabaseDialectAdapter;
import com.openkm.util.EnvironmentDetector;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.QueryTranslator;
import org.hibernate.hql.ast.ASTQueryTranslatorFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static Logger log = LoggerFactory.getLogger(HibernateUtil.class);
    private static SessionFactory sessionFactory;
    public static String HBM2DDL_CREATE;

    private HibernateUtil() {
    }

    public static SessionFactory getSessionFactory() {
        return HibernateUtil.getSessionFactory(Config.HIBERNATE_HBM2DDL);
    }

    private static Configuration getConfiguration() {
        Configuration cfg = new Configuration();
        cfg.addAnnotatedClass(DatabaseMetadataType.class);
        cfg.addAnnotatedClass(DatabaseMetadataValue.class);
        cfg.addAnnotatedClass(DatabaseMetadataSequence.class);
        return cfg;
    }

    public static SessionFactory getSessionFactory(String hbm2ddl) {
        if (sessionFactory == null) {
            try {
                Configuration cfg = HibernateUtil.getConfiguration().configure();
                cfg.setProperty("hibernate.dialect", Config.HIBERNATE_DIALECT);
                cfg.setProperty("hibernate.connection.datasource", Config.HIBERNATE_DATASOURCE);
                cfg.setProperty("hibernate.hbm2ddl.auto", hbm2ddl);
                cfg.setProperty("hibernate.show_sql", Config.HIBERNATE_SHOW_SQL);
                cfg.setProperty("hibernate.generate_statistics", Config.HIBERNATE_STATISTICS);
                log.info("Hibernate 'hibernate.dialect' = {}", (Object)cfg.getProperty("hibernate.dialect"));
                log.info("Hibernate 'hibernate.connection.datasource' = {}", (Object)cfg.getProperty("hibernate.connection.datasource"));
                log.info("Hibernate 'hibernate.hbm2ddl.auto' = {}", (Object)cfg.getProperty("hibernate.hbm2ddl.auto"));
                log.info("Hibernate 'hibernate.show_sql' = {}", (Object)cfg.getProperty("hibernate.show_sql"));
                log.info("Hibernate 'hibernate.generate_statistics' = {}", (Object)cfg.getProperty("hibernate.generate_statistics"));
                sessionFactory = cfg.buildSessionFactory();
                if (HBM2DDL_CREATE.equals(hbm2ddl)) {
                    log.info("Executing specific import for: {}", (Object)Config.HIBERNATE_DIALECT);
                    InputStream is = Config.getResourceAsStream("default.sql");
                    String adapted = DatabaseDialectAdapter.dialectAdapter(is, Config.HIBERNATE_DIALECT);
                    HibernateUtil.executeImport(new StringReader(adapted));
                    IOUtils.closeQuietly((InputStream)is);
                    for (String res : Config.getResources("i18n")) {
                        InputStream isLang = Config.getResourceAsStream("i18n/" + res);
                        log.info("Importing language definition: {}", (Object)res);
                        HibernateUtil.executeImport(new InputStreamReader(isLang));
                        IOUtils.closeQuietly((InputStream)isLang);
                    }
                }
            }
            catch (HibernateException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ExceptionInInitializerError(e);
            }
            catch (URISyntaxException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ExceptionInInitializerError(e);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new ExceptionInInitializerError(e);
            }
        }
        return sessionFactory;
    }

    public static void closeSessionFactory() {
        if (sessionFactory != null) {
            sessionFactory.close();
            sessionFactory = null;
        }
    }

    public static void close(org.hibernate.Session session) {
        if (session != null && session.isOpen()) {
            session.close();
        }
    }

    public static void commit(Transaction tx) {
        if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
            tx.commit();
        }
    }

    public static void rollback(Transaction tx) {
        if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
            tx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Blob fromImageBlob) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buf = new byte[4000];
            InputStream is = fromImageBlob.getBinaryStream();
            try {
                int dataSize;
                while ((dataSize = is.read(buf)) != -1) {
                    baos.write(buf, 0, dataSize);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            return baos.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String toSql(String hql) {
        if (hql != null && hql.trim().length() > 0) {
            ASTQueryTranslatorFactory qtf = new ASTQueryTranslatorFactory();
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            QueryTranslator translator = qtf.createQueryTranslator(hql, hql, Collections.EMPTY_MAP, sfi);
            translator.compile(Collections.EMPTY_MAP, false);
            return translator.getSQLString();
        }
        return null;
    }

    private static void executeImport(final Reader rd) {
        Session session = null;
        Transaction tx = null;
        try {
            session = sessionFactory.openSession();
            tx = session.beginTransaction();
            session.doWork(new Work(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void execute(Connection con) throws SQLException {
                    try {
                        for (HashMap<String, String> error : LegacyDAO.executeScript(con, rd)) {
                            log.error("Error during import script execution at line {}: {} [ {} ]", new Object[]{error.get("ln"), error.get("msg"), error.get("sql")});
                        }
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)rd);
                    }
                }
            });
            HibernateUtil.commit(tx);
        }
        catch (Exception e) {
            HibernateUtil.rollback(tx);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void generateDatabase(String dialect) throws IOException {
        log.info("Exporting Database Schema...");
        String dbSchema = EnvironmentDetector.getUserHome() + "/schema.sql";
        Configuration cfg = HibernateUtil.getConfiguration().configure();
        cfg.setProperty("hibernate.dialect", dialect);
        SchemaExport se = new SchemaExport(cfg);
        se.setOutputFile(dbSchema);
        se.setDelimiter(";");
        se.setFormat(false);
        se.create(false, false);
        log.info("Database Schema exported to {}", (Object)dbSchema);
        String initialData = new File("").getAbsolutePath() + "/src/main/resources/default.sql";
        log.info("Exporting Initial Data from '{}'...", (Object)initialData);
        String initData = EnvironmentDetector.getUserHome() + "/data.sql";
        FileInputStream fis = new FileInputStream(initialData);
        String ret = DatabaseDialectAdapter.dialectAdapter(fis, dialect);
        FileWriter fw = new FileWriter(initData);
        IOUtils.write((String)ret, (Writer)fw);
        fw.flush();
        fw.close();
        log.info("Initial Data exported to {}", (Object)initData);
    }

    static {
        HBM2DDL_CREATE = "create";
    }
}

