/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.KeyValue;
import com.openkm.util.DatabaseMetadataUtils;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueDAO {
    private static Logger log = LoggerFactory.getLogger(KeyValueDAO.class);

    private KeyValueDAO() {
    }

    public static List<KeyValue> getKeyValues(String query) throws DatabaseException {
        log.debug("getKeyValues({})", (Object)query);
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>();
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(query);
            for (Object obj : q.list()) {
                if (!(obj instanceof Object[])) continue;
                Object[] ao = (Object[])obj;
                KeyValue kv = new KeyValue();
                kv.setKey(String.valueOf(ao[0]));
                kv.setValue(String.valueOf(ao[1]));
                ret.add(kv);
            }
            log.debug("getKeyValues: {}", ret);
            ArrayList<KeyValue> arrayList = ret;
            return arrayList;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<KeyValue> getKeyValues(List<String> tables, String query) throws DatabaseException {
        log.debug("getKeyValues({}, {})", tables, (Object)query);
        String realQuery = DatabaseMetadataUtils.replaceVirtual(tables, query);
        List<KeyValue> ret = KeyValueDAO.getKeyValues(realQuery);
        log.debug("getKeyValues: {}", ret);
        return ret;
    }

    public static List<KeyValue> getKeyValues(String table, String query) throws DatabaseException {
        log.debug("getKeyValues({}, {})", (Object)table, (Object)query);
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(table);
        List<KeyValue> ret = KeyValueDAO.getKeyValues(tables, query);
        log.debug("getKeyValues: {}", ret);
        return ret;
    }
}

