/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.core.RepositoryException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Language;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageDAO {
    private static Logger log = LoggerFactory.getLogger(LanguageDAO.class);

    private LanguageDAO() {
    }

    public static Language findByPk(String id) throws DatabaseException {
        log.debug("findByPk({})", (Object)id);
        String qs = "from Language lg where lg.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("id", id);
            Language ret = (Language)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            Language language = ret;
            return language;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Language> findAll() throws DatabaseException, RepositoryException {
        log.debug("findAll({})");
        String qs = "from Language lg order by lg.name asc";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void delete(String id) throws DatabaseException {
        log.debug("delete({})", (Object)id);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Language lang = (Language)session.load(Language.class, (Serializable)((Object)id));
            session.delete((Object)lang);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static void update(Language lang) throws DatabaseException {
        log.debug("update({})", (Object)lang);
        String qs = "select lg.imageContent, lg.imageMime from Language lg where lg.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            if (lang.getImageContent() == null || lang.getImageContent().length() == 0) {
                Query q = session.createQuery(qs);
                q.setParameter("id", (Object)lang.getId());
                Object[] data = (Object[])q.setMaxResults(1).uniqueResult();
                lang.setImageContent((String)data[0]);
                lang.setImageMime((String)data[1]);
            }
            session.update((Object)lang);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void create(Language lang) throws DatabaseException {
        log.debug("create({})", (Object)lang);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)lang);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }
}

