/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.Config;
import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDAO {
    private static Logger log = LoggerFactory.getLogger(LegacyDAO.class);
    private static DataSource ds = null;

    public static Connection getConnection() {
        try {
            if (ds == null) {
                log.info("Looking for {} DataSource...", (Object)Config.HIBERNATE_DATASOURCE);
                InitialContext ctx = new InitialContext();
                ds = (DataSource)ctx.lookup(Config.HIBERNATE_DATASOURCE);
                ctx.close();
            }
            return ds.getConnection();
        }
        catch (NamingException e) {
            log.error("DataSource not found: {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            log.error("Can't get connection from DataSource", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(Connection con, String sql) throws IOException, SQLException {
        Statement stmt = con.createStatement();
        try {
            log.info("execute: {}", (Object)sql);
            stmt.execute(sql);
        }
        finally {
            LegacyDAO.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HashMap<String, String>> executeScript(Connection con, Reader file) throws IOException, SQLException {
        ArrayList<HashMap<String, String>> errors;
        block8: {
            errors = new ArrayList<HashMap<String, String>>();
            BufferedReader br = new BufferedReader(file);
            Statement stmt = con.createStatement();
            String sql = null;
            int lineNo = 0;
            block5: while (true) {
                while ((sql = br.readLine()) != null) {
                    String trimmedSql = sql.trim();
                    ++lineNo;
                    if (trimmedSql.length() <= 0 || trimmedSql.startsWith("--")) continue;
                    try {
                        if (trimmedSql.endsWith(";")) {
                            trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
                        }
                        stmt.execute(trimmedSql);
                        continue block5;
                    }
                    catch (SQLException e) {
                        HashMap<String, String> error = new HashMap<String, String>();
                        error.put("ln", Integer.toString(lineNo));
                        error.put("sql", trimmedSql);
                        error.put("msg", e.getMessage());
                        errors.add(error);
                    }
                }
                break block8;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                LegacyDAO.close(stmt);
            }
        }
        return errors;
    }

    public static void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.warn("Error closing connection: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.warn("Error closing resultset: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.warn("Error closing statement: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static List<Object> executeQuery(String query) throws DatabaseException {
        log.debug("executeValueQuery({})", (Object)query);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("executeValueQuery: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Object executeQueryUnique(String query) throws DatabaseException {
        log.debug("executeQueryUnique({})", (Object)query);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(query);
            Object ret = q.uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("executeQueryUnique: {}", ret);
            Object object = ret;
            return object;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

