/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.LockToken;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockTokenDAO {
    private static Logger log = LoggerFactory.getLogger(LockTokenDAO.class);

    private LockTokenDAO() {
    }

    public static void add(LockToken lt) throws DatabaseException {
        log.debug("add({})", (Object)lt);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)lt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("add: void");
    }

    public static void remove(String user, String token) throws DatabaseException {
        log.debug("remove({}, {})", (Object)user, (Object)token);
        String qs = "delete from LockToken lt where lt.user=:user and lt.token=:token";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            q.setString("token", token);
            q.executeUpdate();
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("remove: void");
    }

    public static List<LockToken> findByUser(String user) throws DatabaseException {
        log.debug("findByUser({})", (Object)user);
        String qs = "from LockToken lt where lt.user=:user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static LockToken findByUserAndToken(String user, String token) throws DatabaseException {
        log.debug("findByUserAndToken({}, {})", (Object)user, (Object)token);
        String qs = "from LockToken lt where lt.user=:user and lt.token=:token";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            q.setString("token", token);
            q.setMaxResults(1);
            List tokens = q.list();
            LockToken lockToken = null;
            if (tokens.size() > 0) {
                lockToken = (LockToken)tokens.get(0);
            }
            log.debug("findByUserAndToken: {}", lockToken);
            LockToken lockToken2 = lockToken;
            return lockToken2;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

