/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.MailAccount;
import com.openkm.dao.bean.MailFilter;
import com.openkm.dao.bean.MailFilterRule;
import java.io.Serializable;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAccountDAO {
    private static Logger log = LoggerFactory.getLogger(MailAccountDAO.class);

    private MailAccountDAO() {
    }

    public static void create(MailAccount ma) throws DatabaseException {
        log.debug("create({})", (Object)ma);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.save((Object)ma);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("create: void");
    }

    public static void update(MailAccount ma) throws DatabaseException {
        log.debug("update({})", (Object)ma);
        String qs = "select ma.mailPassword from MailAccount ma where ma.id=:id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setParameter("id", (Object)ma.getId());
            String pass = (String)q.setMaxResults(1).uniqueResult();
            ma.setMailPassword(pass);
            session.update((Object)ma);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void updatePassword(int maId, String mailPassword) throws DatabaseException {
        log.debug("updatePassword({}, {})", (Object)maId, (Object)mailPassword);
        String qs = "update MailAccount ma set ma.mailPassword=:mailPassword where ma.id=:id";
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            if (mailPassword != null && mailPassword.trim().length() > 0) {
                session = HibernateUtil.getSessionFactory().openSession();
                tx = session.beginTransaction();
                Query q = session.createQuery(qs);
                q.setString("mailPassword", mailPassword);
                q.setInteger("id", maId);
                q.executeUpdate();
                HibernateUtil.commit(tx);
            }
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close(session);
        }
        log.debug("updatePassword: void");
    }

    public static void delete(int maId) throws DatabaseException {
        log.debug("delete({})", (Object)maId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MailAccount ma = (MailAccount)session.load(MailAccount.class, (Serializable)Integer.valueOf(maId));
            session.delete((Object)ma);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static List<MailAccount> findByUser(String usrId, boolean filterByActive) throws DatabaseException {
        log.debug("findByUser({}, {})", (Object)usrId, (Object)filterByActive);
        String qs = "from MailAccount ma where ma.user=:user " + (filterByActive ? "and ma.active=:active" : "") + " order by ma.id";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", usrId);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<MailAccount> findAll(boolean filterByActive) throws DatabaseException {
        log.debug("findAll({})", (Object)filterByActive);
        String qs = "from MailAccount ma " + (filterByActive ? "where ma.active=:active" : "") + " order by ma.id";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static MailAccount findByPk(int maId) throws DatabaseException {
        log.debug("findByPk({})", (Object)maId);
        String qs = "from MailAccount ma where ma.id=:id";
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", maId);
            MailAccount ret = (MailAccount)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            MailAccount mailAccount = ret;
            return mailAccount;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void updateFilter(MailFilter mf) throws DatabaseException {
        log.debug("updateFilter({})", (Object)mf);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)mf);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateFilter: void");
    }

    public static void deleteFilter(int mfId) throws DatabaseException {
        log.debug("deleteFilter({})", (Object)mfId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MailFilter mf = (MailFilter)session.load(MailFilter.class, (Serializable)Integer.valueOf(mfId));
            session.delete((Object)mf);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteFilter: void");
    }

    public static MailFilter findFilterByPk(Session jcrSession, int mfId) throws DatabaseException, RepositoryException {
        log.debug("findFilterByPk({})", (Object)mfId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MailFilter ret = (MailFilter)session.load(MailFilter.class, (Serializable)Integer.valueOf(mfId));
            Node node = jcrSession.getNodeByUUID(ret.getUuid());
            if (!node.getPath().equals(ret.getPath())) {
                ret.setPath(node.getPath());
                session.update((Object)ret);
            }
            HibernateUtil.commit(tx);
            log.debug("findFilterByPk: {}", (Object)ret);
            MailFilter mailFilter = ret;
            return mailFilter;
        }
        catch (RepositoryException e) {
            HibernateUtil.rollback(tx);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void updateRule(MailFilterRule fr) throws DatabaseException {
        log.debug("updateRule({})", (Object)fr);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)fr);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("updateRule: void");
    }

    public static void deleteRule(int frId) throws DatabaseException {
        log.debug("deleteRule({})", (Object)frId);
        org.hibernate.classic.Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MailFilterRule fr = (MailFilterRule)session.load(MailFilterRule.class, (Serializable)Integer.valueOf(frId));
            session.delete((Object)fr);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteRule: void");
    }

    public static MailFilterRule findRuleByPk(int frId) throws DatabaseException {
        log.debug("findRuleByPk({})", (Object)frId);
        org.hibernate.classic.Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            MailFilterRule ret = (MailFilterRule)session.load(MailFilterRule.class, (Serializable)Integer.valueOf(frId));
            log.debug("findRuleByPk: {}", (Object)ret);
            MailFilterRule mailFilterRule = ret;
            return mailFilterRule;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

