/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.MimeType;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeTypeDAO {
    private static Logger log = LoggerFactory.getLogger(MimeTypeDAO.class);

    private MimeTypeDAO() {
    }

    public static int create(MimeType mt) throws DatabaseException {
        log.debug("create({})", (Object)mt);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)mt);
            MimeType mtTmp = (MimeType)session.load(MimeType.class, (Serializable)id);
            for (String extensions : mt.getExtensions()) {
                mtTmp.getExtensions().add(extensions);
            }
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(MimeType mt) throws DatabaseException {
        log.debug("update({})", (Object)mt);
        String qs = "select mt.imageContent, mt.imageMime from MimeType mt where mt.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            if (mt.getImageContent() == null || mt.getImageContent().length() == 0) {
                Query q = session.createQuery(qs);
                q.setParameter("id", (Object)mt.getId());
                Object[] data = (Object[])q.setMaxResults(1).uniqueResult();
                mt.setImageContent((String)data[0]);
                mt.setImageMime((String)data[1]);
            }
            session.update((Object)mt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int mtId) throws DatabaseException {
        log.debug("delete({})", (Object)mtId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            MimeType mt = (MimeType)session.load(MimeType.class, (Serializable)Integer.valueOf(mtId));
            session.delete((Object)mt);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static void deleteAll() throws DatabaseException {
        log.debug("deleteAll()");
        String qs = "from MimeType";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            List ret = session.createQuery(qs).list();
            for (MimeType mt : ret) {
                session.delete((Object)mt);
            }
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("deleteAll: void");
    }

    public static MimeType findByPk(int mtId) throws DatabaseException {
        log.debug("findByPk({})", (Object)mtId);
        String qs = "from MimeType mt where mt.id=:id";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setInteger("id", mtId);
            MimeType ret = (MimeType)q.setMaxResults(1).uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("findByPk: {}", (Object)ret);
            MimeType mimeType = ret;
            return mimeType;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<MimeType> findAll(String sort) throws DatabaseException {
        log.debug("findAll()");
        String qs = "from MimeType mt order by " + sort;
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static MimeType findByName(String name) throws DatabaseException {
        log.debug("findByName({})", (Object)name);
        String qs = "from MimeType mt where mt.name=:name";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query q = session.createQuery(qs);
            q.setString("name", name);
            MimeType ret = (MimeType)q.setMaxResults(1).uniqueResult();
            HibernateUtil.commit(tx);
            log.debug("findByName: {}", (Object)ret);
            MimeType mimeType = ret;
            return mimeType;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

