/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.Profile;
import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileDAO {
    private static Logger log = LoggerFactory.getLogger(ProfileDAO.class);

    private ProfileDAO() {
    }

    public static int create(Profile up) throws DatabaseException {
        log.debug("create({})", (Object)up);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)up);
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(Profile up) throws DatabaseException {
        log.debug("update({})", (Object)up);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)up);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int upId) throws DatabaseException {
        log.debug("delete({})", (Object)upId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Profile up = (Profile)session.load(Profile.class, (Serializable)Integer.valueOf(upId));
            session.delete((Object)up);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static Profile findByPk(int upId) throws DatabaseException {
        log.debug("findByPk({})", (Object)upId);
        String qs = "from Profile prf where prf.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", upId);
            Profile ret = (Profile)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            Profile profile = ret;
            return profile;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<Profile> findAll(boolean filterByActive) throws DatabaseException {
        log.debug("findAll()");
        String qs = "from Profile prf " + (filterByActive ? "where prf.active=:active" : "");
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            if (filterByActive) {
                q.setBoolean("active", true);
            }
            List ret = q.list();
            log.debug("findAll: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static Profile findByUser(String user) throws DatabaseException {
        log.debug("findByUser({})", (Object)user);
        String qs = "select profile from UserConfig uc where uc.user=:user";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            Profile ret = (Profile)q.setMaxResults(1).uniqueResult();
            log.debug("findByUser: {}", (Object)ret);
            Profile profile = ret;
            return profile;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

