/*
 * Decompiled with CFR 0.152.
 */
package com.openkm.dao;

import com.openkm.core.DatabaseException;
import com.openkm.dao.HibernateUtil;
import com.openkm.dao.bean.QueryParams;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParamsDAO {
    private static Logger log = LoggerFactory.getLogger(QueryParamsDAO.class);

    private QueryParamsDAO() {
    }

    public static int create(QueryParams qp) throws DatabaseException {
        log.debug("create({})", (Object)qp);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Integer id = (Integer)session.save((Object)qp);
            QueryParams qpTmp = (QueryParams)session.load(QueryParams.class, (Serializable)id);
            for (String keyword : qp.getKeywords()) {
                qpTmp.getKeywords().add(keyword);
            }
            for (String category : qp.getCategories()) {
                qpTmp.getCategories().add(category);
            }
            for (Map.Entry<String, String> entry : qp.getProperties().entrySet()) {
                qpTmp.getProperties().put(entry.getKey(), entry.getValue());
            }
            HibernateUtil.commit(tx);
            log.debug("create: {}", (Object)id);
            int n = id;
            return n;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void update(QueryParams qp) throws DatabaseException {
        log.debug("update({})", (Object)qp);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            session.update((Object)qp);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("update: void");
    }

    public static void delete(int qpId) throws DatabaseException {
        log.debug("delete({})", (Object)qpId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            QueryParams qp = (QueryParams)session.load(QueryParams.class, (Serializable)Integer.valueOf(qpId));
            session.delete((Object)qp);
            HibernateUtil.commit(tx);
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
        log.debug("delete: void");
    }

    public static QueryParams findByPk(int qpId) throws DatabaseException {
        log.debug("findByPk({})", (Object)qpId);
        String qs = "from QueryParams qp where qp.id=:id";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setInteger("id", qpId);
            QueryParams ret = (QueryParams)q.setMaxResults(1).uniqueResult();
            log.debug("findByPk: {}", (Object)ret);
            QueryParams queryParams = ret;
            return queryParams;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<QueryParams> findByUser(String user) throws DatabaseException {
        log.debug("findByUser({})", (Object)user);
        String qs = "from QueryParams qp where qp.user=:user";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            List ret = q.list();
            HibernateUtil.commit(tx);
            log.debug("findByUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void share(int qpId, String user) throws DatabaseException {
        log.debug("share({})", (Object)qpId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            QueryParams qp = (QueryParams)session.load(QueryParams.class, (Serializable)Integer.valueOf(qpId));
            qp.getShared().add(user);
            session.update((Object)qp);
            HibernateUtil.commit(tx);
            log.debug("share: void");
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static void unshare(int qpId, String user) throws DatabaseException {
        log.debug("share({})", (Object)qpId);
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            tx = session.beginTransaction();
            QueryParams qp = (QueryParams)session.load(QueryParams.class, (Serializable)Integer.valueOf(qpId));
            qp.getShared().remove(user);
            session.update((Object)qp);
            HibernateUtil.commit(tx);
            log.debug("share: void");
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<QueryParams> findShared(String user) throws DatabaseException {
        log.debug("findShared({})", (Object)user);
        String qs = "from QueryParams qp where :user in elements(qp.shared)";
        Session session = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findShared: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<QueryParams> findProposedQueryByMeFromUser(String me, String user) throws DatabaseException {
        log.debug("findProposedQueryByMeFromUser({}, {})", (Object)me);
        String qs = "select qp from QueryParams qp, ProposedQueryReceived pr where pr.user=:me and pr.from=:user and pr in elements(qp.proposedReceived)";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findProposedQueryByMeFromUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }

    public static List<QueryParams> findProposedQueryFromMeToUser(String me, String user) throws DatabaseException {
        log.debug("findProposedQueryFromMeToUser({}, {})", (Object)me);
        String qs = "select qp from QueryParams qp, ProposedQuerySent pr where pr.user=:user and pr.from=:me and pr in elements(qp.proposedSent)";
        Session session = null;
        Transaction tx = null;
        try {
            session = HibernateUtil.getSessionFactory().openSession();
            Query q = session.createQuery(qs);
            q.setString("me", me);
            q.setString("user", user);
            List ret = q.list();
            log.debug("findProposedQueryFromMeToUser: {}", (Object)ret);
            List list = ret;
            return list;
        }
        catch (HibernateException e) {
            HibernateUtil.rollback(tx);
            throw new DatabaseException(e.getMessage(), e);
        }
        finally {
            HibernateUtil.close((org.hibernate.Session)session);
        }
    }
}

